/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import groovy.util.Node;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.plugins.ide.eclipse.GenerateEclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;

public final class ClasspathFile {
    private static final Logger LOGGER = Logging.getLogger(ClasspathFile.class);
    static final String NAME_ITEM = "classpathentry";
    static final String NAME_CHILD = "attributes";
    static final String NAME_GRAND = "attribute";
    static final String NAME_ATTRIBUTE = "gradle_used_by_scope";
    static final String NAME_JRE = "JRE_CONTAINER";

    public void configure(Task task) {
        EclipseClasspath eclipseClasspath = ((GenerateEclipseClasspath)task).getClasspath();
        eclipseClasspath.file(xmlFileContentMerger -> xmlFileContentMerger.withXml(xmlProvider -> {
            Node rootNode = xmlProvider.asNode();
            LOGGER.debug("addAction: rootNode.before improving:{}", (Object)rootNode);
            this.improveEclipseClasspathFile(rootNode);
            LOGGER.debug("addAction: rootNode.after  improving:{}", (Object)rootNode);
        }));
    }

    void improveEclipseClasspathFile(Node rootNode) {
        this.putJreOnModulePath(rootNode);
        this.markMain(rootNode);
        this.markTest(rootNode);
    }

    void markMain(Node rootNode) {
        rootNode.children().stream().filter(i -> i instanceof Node).filter(i -> NAME_ITEM.equals(((Node)i).name())).filter(i -> this.isKindOf((Node)i, "lib")).filter(i -> this.getGradleScope((Node)i).contains("main")).filter(i -> this.hasNoAttributeModule((Node)i)).forEach(i -> this.addAttribute((Node)i, "module"));
    }

    void markTest(Node rootNode) {
        rootNode.children().stream().filter(i -> i instanceof Node).filter(i -> NAME_ITEM.equals(((Node)i).name())).filter(i -> "test".equals(this.getGradleScope((Node)i))).filter(i -> this.hasNoAttributeTest((Node)i)).forEach(i -> this.addAttribute((Node)i, "test"));
    }

    void putJreOnModulePath(Node rootNode) {
        rootNode.children().stream().filter(i -> i instanceof Node).filter(i -> NAME_ITEM.equals(((Node)i).name())).filter(i -> this.isJre((Node)i)).filter(i -> this.hasNoAttributeModule((Node)i)).forEach(i -> this.addAttribute((Node)i, "module"));
    }

    String getGradleScope(Node item) {
        Optional<Node> oGrand;
        String empty = "";
        Optional<Object> oChild = item.children().stream().filter(c -> c instanceof Node).filter(c -> NAME_CHILD.equals(((Node)c).name())).findFirst();
        if (oChild.isPresent() && (oGrand = this.getAttributeNamed((Node)oChild.get(), NAME_ATTRIBUTE)).isPresent()) {
            Node grand = oGrand.get();
            Object value = grand.attribute((Object)"value");
            return null == value ? "" : value.toString();
        }
        return "";
    }

    Optional<Node> getAttributeNamed(Node child, String name) {
        return child.children().stream().filter(g -> g instanceof Node).filter(g -> NAME_GRAND.equals(((Node)g).name())).filter(g -> name.equals(((Node)g).attribute((Object)"name"))).findFirst();
    }

    boolean hasNoAttributeModule(Node item) {
        return item.children().stream().filter(c -> c instanceof Node).filter(c -> NAME_CHILD.equals(((Node)c).name())).filter(c -> this.hasAttributeNamed((Node)c, "module")).findFirst().isEmpty();
    }

    boolean hasNoAttributeTest(Node item) {
        return item.children().stream().filter(c -> c instanceof Node).filter(c -> NAME_CHILD.equals(((Node)c).name())).filter(c -> this.hasAttributeNamed((Node)c, "test")).findFirst().isEmpty();
    }

    boolean hasAttributeNamed(Node child, String name) {
        return this.getAttributeNamed(child, name).isPresent();
    }

    boolean isJre(Node item) {
        Object path = item.attribute((Object)"path");
        return this.isKindOf(item, "con") && null != path && path.toString().contains(NAME_JRE);
    }

    boolean isKindOf(Node item, String kind) {
        Object attr = item.attribute((Object)"kind");
        return kind.equals(attr);
    }

    void addAttribute(Node item, String attributeName) {
        ConcurrentSkipListMap<String, String> map = new ConcurrentSkipListMap<String, String>();
        map.put("name", attributeName);
        map.put("value", "true");
        item.children().stream().filter(c -> c instanceof Node).filter(c -> NAME_CHILD.equals(((Node)c).name())).findFirst().ifPresentOrElse(c -> ((Node)c).appendNode((Object)NAME_GRAND, map), new AddAttribute(item, map));
    }

    private static class AddAttribute
    implements Runnable {
        private final transient Node insItem;
        private final transient Map<String, String> insMap;

        private AddAttribute(Node item, Map<String, String> map) {
            this.insItem = item;
            this.insMap = map;
        }

        @Override
        public void run() {
            this.insItem.appendNode((Object)ClasspathFile.NAME_CHILD).appendNode((Object)ClasspathFile.NAME_GRAND, this.insMap);
        }
    }
}

