/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.tasks.Jar;
import org.javamodularity.moduleplugin.JavaProjectHelper;
import org.javamodularity.moduleplugin.internal.StreamHelper;

public class MergeClassesHelper {
    private static final Logger LOGGER = Logging.getLogger(MergeClassesHelper.class);
    public static final String MERGE_CLASSES_TASK_NAME = "mergeClasses";
    public static final List<String> PRE_JAVA_COMPILE_TASK_NAMES = List.of("compileKotlin", "compileTestFixturesKotlin");
    public static final List<String> POST_JAVA_COMPILE_TASK_NAMES = List.of("compileGroovy");
    private final Project project;

    public MergeClassesHelper(Project project) {
        this.project = project;
    }

    public Project project() {
        return this.project;
    }

    public Stream<CompileTaskWrapper> otherCompileTaskStream() {
        return this.otherCompileTaskNameStream().map(name -> this.helper().findTask((String)name, Task.class)).flatMap(Optional::stream).map(this::toWrapper);
    }

    private Stream<String> otherCompileTaskNameStream() {
        return StreamHelper.concat(PRE_JAVA_COMPILE_TASK_NAMES.stream(), POST_JAVA_COMPILE_TASK_NAMES.stream(), Stream.of("compileModuleInfoJava"));
    }

    private CompileTaskWrapper javaCompileTask() {
        return this.toWrapper((Task)this.helper().task("compileJava", JavaCompile.class));
    }

    public Stream<CompileTaskWrapper> allCompileTaskStream() {
        return Stream.concat(Stream.of(this.javaCompileTask()), this.otherCompileTaskStream());
    }

    public boolean isMergeRequired() {
        return this.otherCompileTaskStream().anyMatch(CompileTaskWrapper::hasSource);
    }

    public Sync createMergeClassesTask() {
        Sync sync = (Sync)this.project.getTasks().create(MERGE_CLASSES_TASK_NAME, Sync.class);
        sync.setDuplicatesStrategy(DuplicatesStrategy.INCLUDE);
        return sync;
    }

    public FileCollection getMergeAdjustedClasspath(FileCollection classpath) {
        boolean mergeRequired;
        File testFixturesJar = this.helper().findTask("testFixturesJar", Jar.class).map(task -> ((RegularFile)task.getArchiveFile().get()).getAsFile()).orElse(null);
        if (testFixturesJar != null) {
            classpath = classpath.minus((FileCollection)this.project.files(new Object[]{testFixturesJar}));
        }
        if (!(mergeRequired = this.isMergeRequired())) {
            return classpath;
        }
        HashSet<File> files = new HashSet<File>(classpath.getFiles());
        this.allCompileTaskStream().map(CompileTaskWrapper::getDestinationDir).forEach(files::remove);
        files.add(this.helper().getMergedDir());
        return this.project.files(files.toArray());
    }

    private CompileTaskWrapper toWrapper(Task task) {
        return task instanceof AbstractCompile ? new GradleTaskWrapper((AbstractCompile)task) : new ReflectionTaskWrapper(task);
    }

    private JavaProjectHelper helper() {
        return new JavaProjectHelper(this.project);
    }

    private static final class ReflectionTaskWrapper
    implements CompileTaskWrapper {
        private final Task task;
        private final Supplier<DirectoryProperty> destinationDir;
        private final Supplier<FileCollection> source;

        ReflectionTaskWrapper(Task task) {
            this.task = task;
            this.destinationDir = ReflectionTaskWrapper.supplier(task, "getDestinationDirectory", DirectoryProperty.class);
            this.source = ReflectionTaskWrapper.supplier(task, "getSources", FileCollection.class);
        }

        @Override
        public Task getTask() {
            return this.task;
        }

        @Override
        public File getDestinationDir() {
            return (File)this.destinationDir.get().getAsFile().getOrNull();
        }

        @Override
        public boolean hasSource() {
            return !this.source.get().isEmpty();
        }

        private static <T> Supplier<T> supplier(Task task, String getterName, Class<T> getterReturnType) {
            Method m = ReflectionTaskWrapper.getMethod(task, getterName);
            return () -> {
                try {
                    Object result = m.invoke((Object)task, new Object[0]);
                    return getterReturnType.cast(result);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof RuntimeException) {
                        throw (RuntimeException)e.getTargetException();
                    }
                    throw new RuntimeException(e.getTargetException());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to invoke " + getterName + " on " + task.getClass(), e);
                }
            };
        }

        private static Method getMethod(Task task, String name) {
            try {
                return task.getClass().getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Method " + name + " missing on " + task.getClass(), e);
            }
        }
    }

    private static final class GradleTaskWrapper
    implements CompileTaskWrapper {
        private final AbstractCompile task;

        GradleTaskWrapper(AbstractCompile task) {
            this.task = task;
        }

        @Override
        public Task getTask() {
            return this.task;
        }

        @Override
        public File getDestinationDir() {
            return this.task.getDestinationDir();
        }

        @Override
        public boolean hasSource() {
            return !this.task.getSource().isEmpty();
        }
    }

    public static interface CompileTaskWrapper {
        public Task getTask();

        public File getDestinationDir();

        public boolean hasSource();
    }
}

