/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.JavaExec;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.extensions.PatchModuleContainer;
import org.javamodularity.moduleplugin.extensions.RunModuleOptions;
import org.javamodularity.moduleplugin.internal.TaskOption;
import org.javamodularity.moduleplugin.tasks.AbstractExecutionMutator;

public class RunTaskMutator
extends AbstractExecutionMutator {
    private static final Logger LOGGER = Logging.getLogger(RunTaskMutator.class);

    public RunTaskMutator(JavaExec execTask, Project project) {
        super(execTask, project);
    }

    public void configureRun() {
        this.execTask.getExtensions().create("moduleOptions", RunModuleOptions.class, new Object[]{this.project});
        this.updateJavaExecTask();
    }

    private void updateJavaExecTask() {
        this.execTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                List<String> jvmArgs = RunTaskMutator.this.buildJavaExecJvmArgs();
                RunTaskMutator.this.execTask.setJvmArgs(jvmArgs);
                RunTaskMutator.this.execTask.setClasspath((FileCollection)RunTaskMutator.this.project.files(new Object[0]));
            }
        });
    }

    private List<String> buildJavaExecJvmArgs() {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        String moduleName = this.helper().moduleName();
        RunModuleOptions moduleOptions = (RunModuleOptions)this.execTask.getExtensions().getByType(RunModuleOptions.class);
        moduleOptions.mutateArgs(jvmArgs);
        FileCollection classpath = this.mergeClassesHelper().getMergeAdjustedClasspath(this.execTask.getClasspath());
        ConfigurableFileCollection filteredClasspath = this.project.files(classpath.getFiles().stream().filter(f -> f.isDirectory() || f.getName().endsWith(".jar") || f.getName().endsWith(".jmod")).collect(Collectors.toList()).toArray());
        PatchModuleContainer patchModuleContainer = PatchModuleContainer.copyOf(this.helper().modularityExtension().optionContainer().getPatchModuleContainer());
        File resourceDir = this.helper().mainSourceSet().getOutput().getResourcesDir();
        if (resourceDir != null && Files.isDirectory(resourceDir.toPath(), new LinkOption[0])) {
            patchModuleContainer.addDir(moduleName, resourceDir.getAbsolutePath());
        }
        patchModuleContainer.buildModulePathOption((FileCollection)filteredClasspath).ifPresent(option -> option.mutateArgs(jvmArgs));
        patchModuleContainer.mutator((FileCollection)filteredClasspath).mutateArgs(jvmArgs);
        jvmArgs.addAll(this.execTask.getJvmArgs());
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) < 0) {
            new TaskOption("--module", this.getMainClassName()).mutateArgs(jvmArgs);
        }
        LOGGER.info("jvmArgs for task {}: {}", (Object)this.execTask.getName(), jvmArgs);
        return jvmArgs;
    }
}

