
package ch.ethz.ssh2.log;

import java.util.logging.Level;

/**
 * Logger - a very simple logger, mainly used during development.
 * Is not based on log4j (to reduce external dependencies).
 * However, if needed, something like log4j could easily be
 * hooked in.
 * 
 * @author Christian Plattner, plattner@inf.ethz.ch
 * @version $Id: Logger.java,v 1.8 2006/10/06 12:55:40 cplattne Exp $
 */

public class Logger
{
    /**
     * Higher the verbose. Between 0-100.
     * Set to -1 to stop logging.
     */
    public static int logLevel = -1;
    
    private static final Level[] LEVEL_CONSTANTS = new Level[100];

    private final java.util.logging.Logger core;

    public static Logger getLogger(Class x)
	{
		return new Logger(x);
	}

	public Logger(Class x)
	{
        this.core = java.util.logging.Logger.getLogger(x.getName());
	}

	public final boolean isEnabled()
	{
		return logLevel>=0;
	}

	public final void log(int level, String message)
	{
		if (level <= logLevel)
		{
            // map level=[0,100) to Level=[500,300)
            Level lv = LEVEL_CONSTANTS[level];
            if(lv==null)
                LEVEL_CONSTANTS[level] = lv = Level.parse(""+(500-level*2));
            
            core.log(lv,message);
		}
	}
}
