/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.xdb;

import java.util.ArrayList;
import java.util.List;
import org.lionsoul.ip2region.xdb.LittleEndian;

public class LongByteArray {
    private final List<byte[]> buffs = new ArrayList<byte[]>();
    private long length;

    public LongByteArray() {
        this.length = 0L;
    }

    public LongByteArray(byte[] buff) {
        this.buffs.add(buff);
        this.length = buff.length;
    }

    public void append(byte[] buffer) {
        this.buffs.add(buffer);
        this.length += (long)buffer.length;
    }

    public long length() {
        return this.length;
    }

    private Position determinate(long offset) {
        int index = 0;
        int position = 0;
        int buffLen = this.buffs.size();
        long curIndex = 0L;
        for (index = 0; index < buffLen; ++index) {
            byte[] buff = this.buffs.get(index);
            if (curIndex + (long)buff.length < offset) {
                curIndex += (long)buff.length;
                continue;
            }
            position = (int)(offset - curIndex);
            break;
        }
        return new Position(index, position);
    }

    public byte[] copy(long srcPos, byte[] dest, int destPos, int length) {
        int buffLen;
        if (srcPos >= this.length) {
            throw new IndexOutOfBoundsException("srcPos exceed the maximum array length `" + this.length + "`");
        }
        if (destPos + length > dest.length) {
            throw new IndexOutOfBoundsException("destPost+length exceed the maximum dest buffer length `" + dest.length + "`");
        }
        Position pos = this.determinate(srcPos);
        byte[] hBuff = this.buffs.get(pos.index++);
        int copyLen = Math.min(hBuff.length - pos.offset, length);
        System.arraycopy(hBuff, pos.offset, dest, destPos, copyLen);
        int sPos = destPos + copyLen;
        for (int left = length - copyLen; left > 0; left -= buffLen) {
            byte[] tBuff;
            if (left <= (buffLen = (tBuff = this.buffs.get(pos.index++)).length)) {
                System.arraycopy(tBuff, 0, dest, sPos, left);
                break;
            }
            System.arraycopy(tBuff, 0, dest, sPos, buffLen);
            sPos += buffLen;
        }
        return dest;
    }

    public byte[] slice(long offset, int length) {
        if (offset + (long)length > this.length) {
            throw new IndexOutOfBoundsException("offset+length exceed the maximum array length `" + this.length + "`");
        }
        byte[] buffer = new byte[length];
        return this.copy(offset, buffer, 0, length);
    }

    public long getUint32(long offset) {
        byte[] b = new byte[4];
        this.copy(offset, b, 0, 4);
        return LittleEndian.getUint32(b, 0);
    }

    public int getInt2(long offset) {
        byte[] b = new byte[4];
        this.copy(offset, b, 0, 4);
        return LittleEndian.getInt2(b, 0);
    }

    public static class Position {
        public int index;
        public int offset;

        public Position(int index, int offset) {
            this.index = index;
            this.offset = offset;
        }
    }
}

