/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cassandra;

import com.datastax.driver.core.Cluster;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.cassandra.CassandraReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.cassandra.CassandraReactiveDataAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Cluster.class, ReactiveCassandraOperations.class, Flux.class})
@ConditionalOnBean(value={ReactiveCassandraOperations.class})
@ConditionalOnEnabledHealthIndicator(value="cassandra")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={CassandraReactiveDataAutoConfiguration.class})
public class CassandraReactiveHealthIndicatorAutoConfiguration
extends CompositeReactiveHealthIndicatorConfiguration<CassandraReactiveHealthIndicator, ReactiveCassandraOperations> {
    @Bean
    @ConditionalOnMissingBean(name={"cassandraHealthIndicator"})
    public ReactiveHealthIndicator cassandraHealthIndicator(Map<String, ReactiveCassandraOperations> reactiveCassandraOperations) {
        return this.createHealthIndicator(reactiveCassandraOperations);
    }
}

