/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.hazelcast.HazelcastHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={HazelcastInstance.class})
@ConditionalOnBean(value={HazelcastInstance.class})
@ConditionalOnEnabledHealthIndicator(value="hazelcast")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={HazelcastAutoConfiguration.class})
public class HazelcastHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<HazelcastHealthIndicator, HazelcastInstance> {
    @Bean
    @ConditionalOnMissingBean(name={"hazelcastHealthIndicator"})
    public HealthIndicator hazelcastHealthIndicator(Map<String, HazelcastInstance> hazelcastInstances) {
        return this.createHealthIndicator(hazelcastInstances);
    }
}

