/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.reactive;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.endpoint.InvalidEndpointRequestException;
import org.springframework.boot.actuate.endpoint.InvocationContext;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvoker;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.WebOperationRequestPredicate;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.condition.ConsumesRequestCondition;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.condition.ProducesRequestCondition;
import org.springframework.web.reactive.result.condition.RequestMethodsRequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;

public abstract class AbstractWebFluxEndpointHandlerMapping
extends RequestMappingInfoHandlerMapping {
    private static final PathPatternParser pathPatternParser = new PathPatternParser();
    private final EndpointMapping endpointMapping;
    private final Collection<ExposableWebEndpoint> endpoints;
    private final EndpointMediaTypes endpointMediaTypes;
    private final CorsConfiguration corsConfiguration;
    private final Method linksMethod = ReflectionUtils.findMethod(((Object)((Object)this)).getClass(), (String)"links", (Class[])new Class[]{ServerWebExchange.class});
    private final Method handleWriteMethod = ReflectionUtils.findMethod(WriteOperationHandler.class, (String)"handle", (Class[])new Class[]{ServerWebExchange.class, Map.class});
    private final Method handleReadMethod = ReflectionUtils.findMethod(ReadOperationHandler.class, (String)"handle", (Class[])new Class[]{ServerWebExchange.class});

    public AbstractWebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration) {
        this.endpointMapping = endpointMapping;
        this.endpoints = endpoints;
        this.endpointMediaTypes = endpointMediaTypes;
        this.corsConfiguration = corsConfiguration;
        this.setOrder(-100);
    }

    protected void initHandlerMethods() {
        for (ExposableWebEndpoint endpoint : this.endpoints) {
            for (WebOperation operation : endpoint.getOperations()) {
                this.registerMappingForOperation(endpoint, operation);
            }
        }
        if (StringUtils.hasText((String)this.endpointMapping.getPath())) {
            this.registerLinksMapping();
        }
    }

    private void registerMappingForOperation(ExposableWebEndpoint endpoint, WebOperation operation) {
        OperationInvoker invoker = operation::invoke;
        if (operation.isBlocking()) {
            invoker = new ElasticSchedulerInvoker(invoker);
        }
        ReactiveWebOperation reactiveWebOperation = this.wrapReactiveWebOperation(endpoint, operation, new ReactiveWebOperationAdapter(invoker));
        if (operation.getType() == OperationType.WRITE) {
            this.registerMapping(this.createRequestMappingInfo(operation), new WriteOperationHandler(reactiveWebOperation), this.handleWriteMethod);
        } else {
            this.registerMapping(this.createRequestMappingInfo(operation), new ReadOperationHandler(reactiveWebOperation), this.handleReadMethod);
        }
    }

    protected ReactiveWebOperation wrapReactiveWebOperation(ExposableWebEndpoint endpoint, WebOperation operation, ReactiveWebOperation reactiveWebOperation) {
        return reactiveWebOperation;
    }

    private RequestMappingInfo createRequestMappingInfo(WebOperation operation) {
        WebOperationRequestPredicate predicate = operation.getRequestPredicate();
        PatternsRequestCondition patterns = new PatternsRequestCondition(new PathPattern[]{pathPatternParser.parse(this.endpointMapping.createSubPath(predicate.getPath()))});
        RequestMethodsRequestCondition methods = new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.valueOf((String)predicate.getHttpMethod().name())});
        ConsumesRequestCondition consumes = new ConsumesRequestCondition(this.toStringArray(predicate.getConsumes()));
        ProducesRequestCondition produces = new ProducesRequestCondition(this.toStringArray(predicate.getProduces()));
        return new RequestMappingInfo(null, patterns, methods, null, null, consumes, produces, null);
    }

    private String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    private void registerLinksMapping() {
        PatternsRequestCondition patterns = new PatternsRequestCondition(new PathPattern[]{pathPatternParser.parse(this.endpointMapping.getPath())});
        RequestMethodsRequestCondition methods = new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.GET});
        ProducesRequestCondition produces = new ProducesRequestCondition(this.endpointMediaTypes.getProduced().toArray(new String[this.endpointMediaTypes.getProduced().size()]));
        RequestMappingInfo mapping = new RequestMappingInfo(patterns, methods, null, null, null, produces, null);
        this.registerMapping(mapping, (Object)this, this.linksMethod);
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mapping) {
        return this.corsConfiguration;
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        return null;
    }

    protected abstract Object links(ServerWebExchange var1);

    public Collection<ExposableWebEndpoint> getEndpoints() {
        return this.endpoints;
    }

    private static final class ReactiveSecurityContext
    implements SecurityContext {
        private final RoleVoter roleVoter = new RoleVoter();
        private final Authentication authentication;

        ReactiveSecurityContext(Authentication authentication) {
            this.authentication = authentication;
        }

        @Override
        public Principal getPrincipal() {
            return this.authentication;
        }

        @Override
        public boolean isUserInRole(String role) {
            if (!role.startsWith(this.roleVoter.getRolePrefix())) {
                role = this.roleVoter.getRolePrefix() + role;
            }
            return this.roleVoter.vote(this.authentication, null, Collections.singletonList(new SecurityConfig(role))) == 1;
        }
    }

    private final class ReadOperationHandler {
        private final ReactiveWebOperation operation;

        ReadOperationHandler(ReactiveWebOperation operation) {
            this.operation = operation;
        }

        @ResponseBody
        public Publisher<ResponseEntity<Object>> handle(ServerWebExchange exchange) {
            return this.operation.handle(exchange, null);
        }
    }

    private final class WriteOperationHandler {
        private final ReactiveWebOperation operation;

        WriteOperationHandler(ReactiveWebOperation operation) {
            this.operation = operation;
        }

        @ResponseBody
        public Publisher<ResponseEntity<Object>> handle(ServerWebExchange exchange, @RequestBody(required=false) Map<String, String> body) {
            return this.operation.handle(exchange, body);
        }
    }

    private static final class ReactiveWebOperationAdapter
    implements ReactiveWebOperation {
        private final OperationInvoker invoker;
        private final Supplier<Mono<? extends SecurityContext>> securityContextSupplier;

        private ReactiveWebOperationAdapter(OperationInvoker invoker) {
            this.invoker = invoker;
            this.securityContextSupplier = this.getSecurityContextSupplier();
        }

        private Supplier<Mono<? extends SecurityContext>> getSecurityContextSupplier() {
            if (ClassUtils.isPresent((String)"org.springframework.security.core.context.ReactiveSecurityContextHolder", (ClassLoader)this.getClass().getClassLoader())) {
                return this::springSecurityContext;
            }
            return this::emptySecurityContext;
        }

        public Mono<? extends SecurityContext> springSecurityContext() {
            return ReactiveSecurityContextHolder.getContext().map(securityContext -> new ReactiveSecurityContext(securityContext.getAuthentication())).switchIfEmpty(Mono.just((Object)new ReactiveSecurityContext(null)));
        }

        public Mono<SecurityContext> emptySecurityContext() {
            return Mono.just((Object)SecurityContext.NONE);
        }

        @Override
        public Mono<ResponseEntity<Object>> handle(ServerWebExchange exchange, Map<String, String> body) {
            Map<String, Object> arguments = this.getArguments(exchange, body);
            return this.securityContextSupplier.get().map(securityContext -> new InvocationContext((SecurityContext)securityContext, arguments)).flatMap(invocationContext -> this.handleResult((Publisher)this.invoker.invoke((InvocationContext)invocationContext), exchange.getRequest().getMethod()));
        }

        private Map<String, Object> getArguments(ServerWebExchange exchange, Map<String, String> body) {
            LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>();
            arguments.putAll(this.getTemplateVariables(exchange));
            if (body != null) {
                arguments.putAll(body);
            }
            exchange.getRequest().getQueryParams().forEach((name, values) -> arguments.put((String)name, values.size() == 1 ? values.get(0) : values));
            return arguments;
        }

        private Map<String, String> getTemplateVariables(ServerWebExchange exchange) {
            return (Map)exchange.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        }

        private Mono<ResponseEntity<Object>> handleResult(Publisher<?> result, HttpMethod httpMethod) {
            return Mono.from(result).map(this::toResponseEntity).onErrorMap(InvalidEndpointRequestException.class, ex -> new ResponseStatusException(HttpStatus.BAD_REQUEST, ex.getReason())).defaultIfEmpty((Object)new ResponseEntity(httpMethod == HttpMethod.GET ? HttpStatus.NOT_FOUND : HttpStatus.NO_CONTENT));
        }

        private ResponseEntity<Object> toResponseEntity(Object response) {
            if (!(response instanceof WebEndpointResponse)) {
                return new ResponseEntity(response, HttpStatus.OK);
            }
            WebEndpointResponse webEndpointResponse = (WebEndpointResponse)response;
            return new ResponseEntity(webEndpointResponse.getBody(), HttpStatus.valueOf((int)webEndpointResponse.getStatus()));
        }
    }

    @FunctionalInterface
    protected static interface ReactiveWebOperation {
        public Mono<ResponseEntity<Object>> handle(ServerWebExchange var1, Map<String, String> var2);
    }

    protected static final class ElasticSchedulerInvoker
    implements OperationInvoker {
        private final OperationInvoker invoker;

        public ElasticSchedulerInvoker(OperationInvoker invoker) {
            this.invoker = invoker;
        }

        @Override
        public Object invoke(InvocationContext context) {
            return Mono.create(sink -> Schedulers.elastic().schedule(() -> this.invoke(context, (MonoSink<Object>)sink)));
        }

        private void invoke(InvocationContext context, MonoSink<Object> sink) {
            try {
                Object result = this.invoker.invoke(context);
                sink.success(result);
            }
            catch (Exception ex) {
                sink.error((Throwable)ex);
            }
        }
    }
}

