/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class HealthIndicatorReactiveAdapter
implements ReactiveHealthIndicator {
    private final HealthIndicator delegate;

    public HealthIndicatorReactiveAdapter(HealthIndicator delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
    }

    @Override
    public Mono<Health> health() {
        return Mono.fromCallable(this.delegate::health).subscribeOn(Schedulers.elastic());
    }
}

