/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.management;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class PlainTextThreadDumpFormatter {
    PlainTextThreadDumpFormatter() {
    }

    String format(ThreadInfo[] threads) {
        StringWriter dump = new StringWriter();
        PrintWriter writer = new PrintWriter(dump);
        this.writePreamble(writer);
        for (ThreadInfo info : threads) {
            this.writeThread(writer, info);
        }
        return dump.toString();
    }

    private void writePreamble(PrintWriter writer) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        writer.println(dateFormat.format(new Date()));
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        writer.printf("Full thread dump %s (%s %s):%n", runtime.getVmName(), runtime.getVmVersion(), System.getProperty("java.vm.info"));
        writer.println();
    }

    private void writeThread(PrintWriter writer, ThreadInfo info) {
        writer.printf("\"%s\" - Thread t@%d%n", info.getThreadName(), info.getThreadId());
        writer.printf("   %s: %s%n", new Object[]{Thread.State.class.getCanonicalName(), info.getThreadState()});
        this.writeStackTrace(writer, info, info.getLockedMonitors());
        writer.println();
        this.writeLockedOwnableSynchronizers(writer, info);
        writer.println();
    }

    private void writeStackTrace(PrintWriter writer, ThreadInfo info, MonitorInfo[] lockedMonitors) {
        int depth = 0;
        for (StackTraceElement element : info.getStackTrace()) {
            this.writeStackTraceElement(writer, element, info, this.lockedMonitorsForDepth(lockedMonitors, depth), depth == 0);
            ++depth;
        }
    }

    private List<MonitorInfo> lockedMonitorsForDepth(MonitorInfo[] lockedMonitors, int depth) {
        return Stream.of(lockedMonitors).filter(lockedMonitor -> lockedMonitor.getLockedStackDepth() == depth).collect(Collectors.toList());
    }

    private void writeStackTraceElement(PrintWriter writer, StackTraceElement element, ThreadInfo info, List<MonitorInfo> lockedMonitors, boolean firstElement) {
        writer.printf("\tat %s%n", element.toString());
        LockInfo lockInfo = info.getLockInfo();
        if (firstElement && lockInfo != null) {
            if (element.getClassName().equals(Object.class.getName()) && element.getMethodName().equals("wait")) {
                if (lockInfo != null) {
                    writer.printf("\t- waiting on %s%n", this.format(lockInfo));
                }
            } else {
                String lockOwner = info.getLockOwnerName();
                if (lockOwner != null) {
                    writer.printf("\t- waiting to lock %s owned by \"%s\" t@%d%n", this.format(lockInfo), lockOwner, info.getLockOwnerId());
                } else {
                    writer.printf("\t- parking to wait for %s%n", this.format(lockInfo));
                }
            }
        }
        this.writeMonitors(writer, lockedMonitors);
    }

    private String format(LockInfo lockInfo) {
        return String.format("<%x> (a %s)", lockInfo.getIdentityHashCode(), lockInfo.getClassName());
    }

    private void writeMonitors(PrintWriter writer, List<MonitorInfo> lockedMonitorsAtCurrentDepth) {
        for (MonitorInfo lockedMonitor : lockedMonitorsAtCurrentDepth) {
            writer.printf("\t- locked %s%n", this.format(lockedMonitor));
        }
    }

    private void writeLockedOwnableSynchronizers(PrintWriter writer, ThreadInfo info) {
        writer.println("   Locked ownable synchronizers:");
        LockInfo[] lockedSynchronizers = info.getLockedSynchronizers();
        if (lockedSynchronizers == null || lockedSynchronizers.length == 0) {
            writer.println("\t- None");
        } else {
            for (LockInfo lockedSynchronizer : lockedSynchronizers) {
                writer.printf("\t- Locked %s%n", this.format(lockedSynchronizer));
            }
        }
    }
}

