/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.SecurityPrequisite;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.stereotype.Component;

@Configuration
@ConditionalOnBean(value={ObjectPostProcessor.class})
@ConditionalOnMissingBean(value={AuthenticationManager.class})
@Order(value=0)
public class AuthenticationManagerConfiguration {
    private static Log logger = LogFactory.getLog(AuthenticationManagerConfiguration.class);
    @Autowired
    private List<SecurityPrequisite> dependencies;

    @Bean
    @Primary
    public AuthenticationManager authenticationManager(AuthenticationConfiguration auth) throws Exception {
        return auth.getAuthenticationManager();
    }

    @Bean
    public static BootDefaultingAuthenticationConfigurerAdapter bootDefaultingAuthenticationConfigurerAdapter(SecurityProperties security, List<SecurityPrequisite> dependencies) {
        return new BootDefaultingAuthenticationConfigurerAdapter(security);
    }

    @Order(value=2147483547)
    private static class BootDefaultingAuthenticationConfigurerAdapter
    extends GlobalAuthenticationConfigurerAdapter {
        private final SecurityProperties security;

        @Autowired
        public BootDefaultingAuthenticationConfigurerAdapter(SecurityProperties security) {
            this.security = security;
        }

        public void init(AuthenticationManagerBuilder auth) throws Exception {
            if (auth.isConfigured()) {
                return;
            }
            SecurityProperties.User user = this.security.getUser();
            if (user.isDefaultPassword()) {
                logger.info((Object)("\n\nUsing default security password: " + user.getPassword() + "\n\n"));
            }
            LinkedHashSet<String> roles = new LinkedHashSet<String>(user.getRole());
            auth.inMemoryAuthentication().withUser(user.getName()).password(user.getPassword()).roles(roles.toArray(new String[roles.size()]));
        }
    }

    @Component
    protected static class AuthenticationManagerConfigurationListener
    implements ApplicationListener<ContextRefreshedEvent> {
        @Autowired
        private AuthenticationEventPublisher authenticationEventPublisher;

        protected AuthenticationManagerConfigurationListener() {
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            ApplicationContext context = event.getApplicationContext();
            if (context.getBeanNamesForType(AuthenticationManager.class).length == 0) {
                return;
            }
            AuthenticationManager manager = (AuthenticationManager)context.getBean(AuthenticationManager.class);
            if (manager instanceof ProviderManager) {
                ((ProviderManager)manager).setAuthenticationEventPublisher(this.authenticationEventPublisher);
            }
        }
    }
}

