/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.client;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.context.properties.bind.convert.BinderConversionService;
import org.springframework.core.convert.ConversionException;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

final class OAuth2ClientPropertiesRegistrationAdapter {
    private OAuth2ClientPropertiesRegistrationAdapter() {
    }

    public static Map<String, ClientRegistration> getClientRegistrations(OAuth2ClientProperties properties) {
        HashMap<String, ClientRegistration> clientRegistrations = new HashMap<String, ClientRegistration>();
        properties.getRegistration().forEach((key, value) -> clientRegistrations.put((String)key, OAuth2ClientPropertiesRegistrationAdapter.getClientRegistration(key, value, properties.getProvider())));
        return clientRegistrations;
    }

    private static ClientRegistration getClientRegistration(String registrationId, OAuth2ClientProperties.Registration properties, Map<String, OAuth2ClientProperties.Provider> providers) {
        ClientRegistration.Builder builder = OAuth2ClientPropertiesRegistrationAdapter.getBuilder(registrationId, properties.getProvider(), providers);
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(properties::getClientId, arg_0 -> ((ClientRegistration.Builder)builder).clientId(arg_0));
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(properties::getClientSecret, arg_0 -> ((ClientRegistration.Builder)builder).clientSecret(arg_0));
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(properties::getClientAuthenticationMethod, arg_0 -> ((ClientRegistration.Builder)builder).clientAuthenticationMethod(arg_0), ClientAuthenticationMethod::new);
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(properties::getAuthorizationGrantType, arg_0 -> ((ClientRegistration.Builder)builder).authorizationGrantType(arg_0), AuthorizationGrantType::new);
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(properties::getRedirectUriTemplate, arg_0 -> ((ClientRegistration.Builder)builder).redirectUriTemplate(arg_0));
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(properties::getScope, arg_0 -> ((ClientRegistration.Builder)builder).scope(arg_0), scope -> scope.toArray(new String[scope.size()]));
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(properties::getClientName, arg_0 -> ((ClientRegistration.Builder)builder).clientName(arg_0));
        return builder.build();
    }

    private static ClientRegistration.Builder getBuilder(String registrationId, String configuredProviderId, Map<String, OAuth2ClientProperties.Provider> providers) {
        ClientRegistration.Builder builder;
        String providerId = configuredProviderId == null ? registrationId : configuredProviderId;
        CommonOAuth2Provider provider = OAuth2ClientPropertiesRegistrationAdapter.getCommonProvider(providerId);
        if (provider == null && !providers.containsKey(providerId)) {
            throw new IllegalStateException(OAuth2ClientPropertiesRegistrationAdapter.getErrorMessage(configuredProviderId, registrationId));
        }
        ClientRegistration.Builder builder2 = builder = provider != null ? provider.getBuilder(registrationId) : ClientRegistration.withRegistrationId((String)registrationId);
        if (providers.containsKey(providerId)) {
            return OAuth2ClientPropertiesRegistrationAdapter.getBuilder(builder, providers.get(providerId));
        }
        return builder;
    }

    private static String getErrorMessage(String configuredProviderId, String registrationId) {
        return configuredProviderId == null ? "Provider ID must be specified for client registration '" + registrationId + "'" : "Unknown provider ID '" + configuredProviderId + "'";
    }

    private static ClientRegistration.Builder getBuilder(ClientRegistration.Builder builder, OAuth2ClientProperties.Provider provider) {
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(provider::getAuthorizationUri, arg_0 -> ((ClientRegistration.Builder)builder).authorizationUri(arg_0));
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(provider::getTokenUri, arg_0 -> ((ClientRegistration.Builder)builder).tokenUri(arg_0));
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(provider::getUserInfoUri, arg_0 -> ((ClientRegistration.Builder)builder).userInfoUri(arg_0));
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(provider::getJwkSetUri, arg_0 -> ((ClientRegistration.Builder)builder).jwkSetUri(arg_0));
        return builder;
    }

    private static CommonOAuth2Provider getCommonProvider(String providerId) {
        try {
            return (CommonOAuth2Provider)new BinderConversionService(null).convert((Object)providerId, CommonOAuth2Provider.class);
        }
        catch (ConversionException ex) {
            return null;
        }
    }

    private static <T> void copyIfNotNull(Supplier<T> supplier, Consumer<T> consumer) {
        OAuth2ClientPropertiesRegistrationAdapter.copyIfNotNull(supplier, consumer, Function.identity());
    }

    private static <S, C> void copyIfNotNull(Supplier<S> supplier, Consumer<C> consumer, Function<S, C> converter) {
        S value = supplier.get();
        if (value != null) {
            consumer.accept(converter.apply(value));
        }
    }
}

