/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.jar;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class PackagedSpringApplicationLauncher {
    public static final String SOURCE_ENTRY = "Spring-Application-Source-Classes";
    public static final String START_CLASS_ENTRY = "Start-Class";
    private static final String SPRING_APPLICATION_CLASS = "org.springframework.boot.SpringApplication";

    private void run(String[] args) throws Exception {
        URLClassLoader classLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        Class<?> application = classLoader.loadClass(SPRING_APPLICATION_CLASS);
        Method method = application.getMethod("run", Object[].class, String[].class);
        method.invoke(null, this.getSources(classLoader), args);
    }

    private Object[] getSources(URLClassLoader classLoader) throws Exception {
        Enumeration<URL> urls = classLoader.findResources("META-INF/MANIFEST.MF");
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            Manifest manifest = new Manifest(url.openStream());
            if (!this.isCliPackaged(manifest)) continue;
            String sources = manifest.getMainAttributes().getValue(SOURCE_ENTRY);
            return this.loadClasses(classLoader, sources.split(","));
        }
        throw new IllegalStateException("Cannot locate Spring-Application-Source-Classes in MANIFEST.MF");
    }

    private boolean isCliPackaged(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String startClass = attributes.getValue(START_CLASS_ENTRY);
        return this.getClass().getName().equals(startClass);
    }

    private Class<?>[] loadClasses(ClassLoader classLoader, String[] names) throws ClassNotFoundException {
        Class[] classes = new Class[names.length];
        for (int i = 0; i < names.length; ++i) {
            classes[i] = classLoader.loadClass(names[i]);
        }
        return classes;
    }

    public static void main(String[] args) throws Exception {
        new PackagedSpringApplicationLauncher().run(args);
    }
}

