/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.springframework.boot.configurationprocessor.metadata.ItemDeprecation;
import org.springframework.boot.configurationprocessor.metadata.ItemHint;
import org.springframework.boot.configurationprocessor.metadata.ItemMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

public class ConfigurationMetadata {
    private static final List<Character> SEPARATORS = Arrays.asList(Character.valueOf('-'), Character.valueOf('_'));
    private final MultiValueMap<String, ItemMetadata> items;
    private final MultiValueMap<String, ItemHint> hints;

    public ConfigurationMetadata() {
        this.items = new LinkedMultiValueMap();
        this.hints = new LinkedMultiValueMap();
    }

    public ConfigurationMetadata(ConfigurationMetadata metadata) {
        this.items = new LinkedMultiValueMap(metadata.items);
        this.hints = new LinkedMultiValueMap(metadata.hints);
    }

    public void add(ItemMetadata itemMetadata) {
        this.items.add((Object)itemMetadata.getName(), (Object)itemMetadata);
    }

    public void add(ItemHint itemHint) {
        this.hints.add((Object)itemHint.getName(), (Object)itemHint);
    }

    public void merge(ConfigurationMetadata metadata) {
        for (ItemMetadata additionalItem : metadata.getItems()) {
            this.mergeItemMetadata(additionalItem);
        }
        for (ItemHint itemHint : metadata.getHints()) {
            this.add(itemHint);
        }
    }

    public List<ItemMetadata> getItems() {
        return ConfigurationMetadata.flattenValues(this.items);
    }

    public List<ItemHint> getHints() {
        return ConfigurationMetadata.flattenValues(this.hints);
    }

    protected void mergeItemMetadata(ItemMetadata metadata) {
        ItemMetadata matching = this.findMatchingItemMetadata(metadata);
        if (matching != null) {
            if (metadata.getDescription() != null) {
                matching.setDescription(metadata.getDescription());
            }
            if (metadata.getDefaultValue() != null) {
                matching.setDefaultValue(metadata.getDefaultValue());
            }
            ItemDeprecation deprecation = metadata.getDeprecation();
            ItemDeprecation matchingDeprecation = matching.getDeprecation();
            if (deprecation != null) {
                if (matchingDeprecation == null) {
                    matching.setDeprecation(deprecation);
                } else {
                    if (deprecation.getReason() != null) {
                        matchingDeprecation.setReason(deprecation.getReason());
                    }
                    if (deprecation.getReplacement() != null) {
                        matchingDeprecation.setReplacement(deprecation.getReplacement());
                    }
                }
            }
        } else {
            this.items.add((Object)metadata.getName(), (Object)metadata);
        }
    }

    private ItemMetadata findMatchingItemMetadata(ItemMetadata metadata) {
        List candidates = (List)this.items.get((Object)metadata.getName());
        if (CollectionUtils.isEmpty((Collection)candidates)) {
            return null;
        }
        ListIterator it = candidates.listIterator();
        while (it.hasNext()) {
            if (((ItemMetadata)it.next()).hasSameType(metadata)) continue;
            it.remove();
        }
        if (candidates.size() == 1) {
            return (ItemMetadata)candidates.get(0);
        }
        for (ItemMetadata candidate : candidates) {
            if (!ObjectUtils.nullSafeEquals((Object)candidate.getSourceType(), (Object)metadata.getSourceType())) continue;
            return candidate;
        }
        return null;
    }

    public static String nestedPrefix(String prefix, String name) {
        String nestedPrefix = prefix == null ? "" : prefix;
        String dashedName = ConfigurationMetadata.toDashedCase(name);
        nestedPrefix = nestedPrefix + ("".equals(nestedPrefix) ? dashedName : "." + dashedName);
        return nestedPrefix;
    }

    static String toDashedCase(String name) {
        StringBuilder sb = new StringBuilder();
        Character previous = null;
        for (char current : name.toCharArray()) {
            if (SEPARATORS.contains(Character.valueOf(current))) {
                sb.append("-");
            } else if (Character.isUpperCase(current) && previous != null && !SEPARATORS.contains(previous)) {
                sb.append("-").append(current);
            } else {
                sb.append(current);
            }
            previous = Character.valueOf(current);
        }
        return sb.toString().toLowerCase();
    }

    private static <T extends Comparable<T>> List<T> flattenValues(MultiValueMap<?, T> map) {
        ArrayList content = new ArrayList();
        for (List values : map.values()) {
            content.addAll(values);
        }
        Collections.sort(content);
        return content;
    }
}

