/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.springframework.boot.configurationprocessor.ConstructorParameterPropertyDescriptor;
import org.springframework.boot.configurationprocessor.JavaBeanPropertyDescriptor;
import org.springframework.boot.configurationprocessor.LombokPropertyDescriptor;
import org.springframework.boot.configurationprocessor.MetadataGenerationEnvironment;
import org.springframework.boot.configurationprocessor.PropertyDescriptor;
import org.springframework.boot.configurationprocessor.TypeElementMembers;

class PropertyDescriptorResolver {
    private final MetadataGenerationEnvironment environment;

    PropertyDescriptorResolver(MetadataGenerationEnvironment environment) {
        this.environment = environment;
    }

    Stream<PropertyDescriptor<?>> resolve(TypeElement type, ExecutableElement factoryMethod) {
        TypeElementMembers members = new TypeElementMembers(this.environment, type);
        ExecutableElement constructor = this.resolveConstructor(type);
        if (constructor != null) {
            return this.resolveConstructorProperties(type, factoryMethod, members, constructor);
        }
        return this.resolveJavaBeanProperties(type, factoryMethod, members);
    }

    Stream<PropertyDescriptor<?>> resolveConstructorProperties(TypeElement type, ExecutableElement factoryMethod, TypeElementMembers members, ExecutableElement constructor) {
        LinkedHashMap candidates = new LinkedHashMap();
        constructor.getParameters().forEach(parameter -> {
            String name = parameter.getSimpleName().toString();
            TypeMirror propertyType = parameter.asType();
            ExecutableElement getter = members.getPublicGetter(name, propertyType);
            ExecutableElement setter = members.getPublicSetter(name, propertyType);
            VariableElement field = members.getFields().get(name);
            this.register(candidates, new ConstructorParameterPropertyDescriptor(type, factoryMethod, (VariableElement)parameter, name, propertyType, field, getter, setter));
        });
        return candidates.values().stream();
    }

    Stream<PropertyDescriptor<?>> resolveJavaBeanProperties(TypeElement type, ExecutableElement factoryMethod, TypeElementMembers members) {
        LinkedHashMap candidates = new LinkedHashMap();
        members.getPublicGetters().forEach((name, getter) -> {
            TypeMirror propertyType = getter.getReturnType();
            this.register(candidates, new JavaBeanPropertyDescriptor(type, factoryMethod, (ExecutableElement)getter, (String)name, propertyType, members.getFields().get(name), members.getPublicSetter((String)name, propertyType)));
        });
        members.getFields().forEach((name, field) -> {
            TypeMirror propertyType = field.asType();
            ExecutableElement getter = members.getPublicGetter((String)name, propertyType);
            ExecutableElement setter = members.getPublicSetter((String)name, propertyType);
            this.register(candidates, new LombokPropertyDescriptor(type, factoryMethod, (VariableElement)field, (String)name, propertyType, getter, setter));
        });
        return candidates.values().stream();
    }

    private void register(Map<String, PropertyDescriptor<?>> candidates, PropertyDescriptor<?> descriptor) {
        if (!candidates.containsKey(descriptor.getName()) && this.isCandidate(descriptor)) {
            candidates.put(descriptor.getName(), descriptor);
        }
    }

    private boolean isCandidate(PropertyDescriptor<?> descriptor) {
        return descriptor.isProperty(this.environment) || descriptor.isNested(this.environment);
    }

    private ExecutableElement resolveConstructor(TypeElement type) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getEnclosedElements());
        if (constructors.size() == 1 && constructors.get(0).getParameters().size() > 0) {
            return constructors.get(0);
        }
        return null;
    }
}

