/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle;

import groovy.lang.Closure;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.springframework.boot.gradle.buildinfo.BuildInfo;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.Layouts;

public class SpringBootPluginExtension {
    private final Project project;
    String mainClass;
    String classifier;
    String providedConfiguration;
    String customConfiguration;
    boolean backupSource = true;
    LayoutType layout;
    Set<String> requiresUnpack;
    boolean excludeDevtools = false;
    File agent;
    Boolean noverify;
    boolean applyExcludeRules = true;
    boolean executable = false;
    File embeddedLaunchScript;
    Map<String, String> embeddedLaunchScriptProperties;

    public SpringBootPluginExtension(Project project) {
        this.project = project;
    }

    public Layout convertLayout() {
        return this.layout == null ? null : this.layout.layout;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getProvidedConfiguration() {
        return this.providedConfiguration;
    }

    public void setProvidedConfiguration(String providedConfiguration) {
        this.providedConfiguration = providedConfiguration;
    }

    public String getCustomConfiguration() {
        return this.customConfiguration;
    }

    public void setCustomConfiguration(String customConfiguration) {
        this.customConfiguration = customConfiguration;
    }

    public boolean isBackupSource() {
        return this.backupSource;
    }

    public void setBackupSource(boolean backupSource) {
        this.backupSource = backupSource;
    }

    public LayoutType getLayout() {
        return this.layout;
    }

    public void setLayout(LayoutType layout) {
        this.layout = layout;
    }

    public Set<String> getRequiresUnpack() {
        return this.requiresUnpack;
    }

    public void setRequiresUnpack(Set<String> requiresUnpack) {
        this.requiresUnpack = requiresUnpack;
    }

    public boolean isExcludeDevtools() {
        return this.excludeDevtools;
    }

    public void setExcludeDevtools(boolean excludeDevtools) {
        this.excludeDevtools = excludeDevtools;
    }

    public File getAgent() {
        return this.agent;
    }

    public void setAgent(File agent) {
        this.agent = agent;
    }

    public Boolean getNoverify() {
        return this.noverify;
    }

    public void setNoverify(Boolean noverify) {
        this.noverify = noverify;
    }

    public boolean isApplyExcludeRules() {
        return this.applyExcludeRules;
    }

    public void setApplyExcludeRules(boolean applyExcludeRules) {
        this.applyExcludeRules = applyExcludeRules;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public File getEmbeddedLaunchScript() {
        return this.embeddedLaunchScript;
    }

    public void setEmbeddedLaunchScript(File embeddedLaunchScript) {
        this.embeddedLaunchScript = embeddedLaunchScript;
    }

    public Map<String, String> getEmbeddedLaunchScriptProperties() {
        return this.embeddedLaunchScriptProperties;
    }

    public void setEmbeddedLaunchScriptProperties(Map<String, String> embeddedLaunchScriptProperties) {
        this.embeddedLaunchScriptProperties = embeddedLaunchScriptProperties;
    }

    public void buildInfo() {
        this.buildInfo(null);
    }

    public void buildInfo(Closure<?> taskConfigurer) {
        BuildInfo bootBuildInfo = (BuildInfo)this.project.getTasks().create("bootBuildInfo", BuildInfo.class);
        this.project.getTasks().getByName("classes").dependsOn(new Object[]{bootBuildInfo});
        if (taskConfigurer != null) {
            taskConfigurer.setDelegate((Object)bootBuildInfo);
            taskConfigurer.call();
        }
    }

    static enum LayoutType {
        JAR((Layout)new Layouts.Jar()),
        WAR((Layout)new Layouts.War()),
        ZIP((Layout)new Layouts.Expanded()),
        DIR((Layout)new Layouts.Expanded()),
        MODULE((Layout)new Layouts.Module()),
        NONE((Layout)new Layouts.None());

        Layout layout;

        private LayoutType(Layout layout) {
            this.layout = layout;
        }
    }
}

