/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.run;

import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.springframework.boot.gradle.PluginFeatures;
import org.springframework.boot.gradle.run.BootRunTask;
import org.springframework.boot.gradle.run.FindMainClassTask;
import org.springframework.boot.gradle.run.SourceSets;

public class RunPluginFeatures
implements PluginFeatures {
    private static final String FIND_MAIN_CLASS_TASK_NAME = "findMainClass";
    private static final String RUN_APP_TASK_NAME = "bootRun";

    @Override
    public void apply(Project project) {
        this.mainClassNameFinder(project);
        this.addBootRunTask(project);
    }

    private void mainClassNameFinder(Project project) {
        FindMainClassTask findMainClassTask = (FindMainClassTask)project.getTasks().create(FIND_MAIN_CLASS_TASK_NAME, FindMainClassTask.class);
        SourceSet mainSourceSet = SourceSets.findMainSourceSet(project);
        if (mainSourceSet != null) {
            findMainClassTask.setMainClassSourceSetOutput(mainSourceSet.getOutput());
        }
        project.getTasks().all((Action)new Action<Task>(){

            public void execute(Task task) {
                if (task instanceof BootRunTask || task instanceof CreateStartScripts) {
                    task.dependsOn(new Object[]{RunPluginFeatures.FIND_MAIN_CLASS_TASK_NAME});
                }
            }
        });
    }

    private void addBootRunTask(final Project project) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        BootRunTask run = (BootRunTask)project.getTasks().create(RUN_APP_TASK_NAME, BootRunTask.class);
        run.setDescription("Run the project with support for auto-detecting main class and reloading static resources");
        run.setGroup("application");
        run.setClasspath(((SourceSet)javaConvention.getSourceSets().findByName("main")).getRuntimeClasspath());
        run.getConventionMapping().map("main", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (project.hasProperty("mainClassName") && project.property("mainClassName") != null) {
                    return project.property("mainClassName");
                }
                ExtraPropertiesExtension extraPropertiesExtension = (ExtraPropertiesExtension)project.getExtensions().getByName("ext");
                if (extraPropertiesExtension.has("mainClassName") && extraPropertiesExtension.get("mainClassName") != null) {
                    return extraPropertiesExtension.get("mainClassName");
                }
                return null;
            }
        });
        run.getConventionMapping().map("jvmArgs", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (project.hasProperty("applicationDefaultJvmArgs")) {
                    return project.property("applicationDefaultJvmArgs");
                }
                return Collections.emptyList();
            }
        });
    }
}

