/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import groovy.lang.Closure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.util.ConfigureUtil;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.Layers;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.layer.ApplicationContentFilter;
import org.springframework.boot.loader.tools.layer.ContentFilter;
import org.springframework.boot.loader.tools.layer.ContentSelector;
import org.springframework.boot.loader.tools.layer.CustomLayers;
import org.springframework.boot.loader.tools.layer.IncludeExcludeContentSelector;
import org.springframework.boot.loader.tools.layer.LibraryContentFilter;
import org.springframework.util.Assert;

public class LayeredSpec {
    private boolean includeLayerTools = true;
    private boolean enabled = true;
    private ApplicationSpec application = new ApplicationSpec(new IntoLayerSpec[0]);
    private DependenciesSpec dependencies = new DependenciesSpec(new DependenciesIntoLayerSpec[0]);
    @Optional
    private List<String> layerOrder;
    private Layers layers;

    @Input
    public boolean isIncludeLayerTools() {
        return this.includeLayerTools;
    }

    public void setIncludeLayerTools(boolean includeLayerTools) {
        this.includeLayerTools = includeLayerTools;
    }

    @Input
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Input
    public ApplicationSpec getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationSpec spec) {
        this.application = spec;
    }

    public void application(Action<ApplicationSpec> action) {
        action.execute((Object)this.application);
    }

    public void application(Closure<?> closure) {
        this.application((Action<ApplicationSpec>)ConfigureUtil.configureUsing(closure));
    }

    @Input
    public DependenciesSpec getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(DependenciesSpec spec) {
        this.dependencies = spec;
    }

    public void dependencies(Action<DependenciesSpec> action) {
        action.execute((Object)this.dependencies);
    }

    public void dependencies(Closure<?> closure) {
        this.dependencies((Action<DependenciesSpec>)ConfigureUtil.configureUsing(closure));
    }

    @Input
    public List<String> getLayerOrder() {
        return this.layerOrder;
    }

    public void setLayerOrder(String ... layerOrder) {
        this.layerOrder = Arrays.asList(layerOrder);
    }

    public void setLayerOrder(List<String> layerOrder) {
        this.layerOrder = layerOrder;
    }

    Layers asLayers() {
        Layers layers = this.layers;
        if (layers == null) {
            this.layers = layers = this.createLayers();
        }
        return layers;
    }

    private Layers createLayers() {
        if (this.layerOrder == null || this.layerOrder.isEmpty()) {
            Assert.state((this.application.isEmpty() && this.dependencies.isEmpty() ? 1 : 0) != 0, (String)"The 'layerOrder' must be defined when using custom layering");
            return Layers.IMPLICIT;
        }
        List layers = this.layerOrder.stream().map(Layer::new).collect(Collectors.toList());
        return new CustomLayers(layers, this.application.asSelectors(), this.dependencies.asSelectors());
    }

    public static class DependenciesSpec
    extends IntoLayersSpec
    implements Serializable {
        public DependenciesSpec(DependenciesIntoLayerSpec ... contents) {
            super(new IntoLayerSpecFactory(), contents);
        }

        List<ContentSelector<Library>> asSelectors() {
            return this.asSelectors(spec -> ((DependenciesIntoLayerSpec)spec).asLibrarySelector(LibraryContentFilter::new));
        }

        private static final class IntoLayerSpecFactory
        implements Function<String, IntoLayerSpec>,
        Serializable {
            private IntoLayerSpecFactory() {
            }

            @Override
            public IntoLayerSpec apply(String layer) {
                return new DependenciesIntoLayerSpec(layer);
            }
        }
    }

    public static class ApplicationSpec
    extends IntoLayersSpec {
        public ApplicationSpec(IntoLayerSpec ... contents) {
            super(new IntoLayerSpecFactory(), contents);
        }

        List<ContentSelector<String>> asSelectors() {
            return this.asSelectors(spec -> spec.asSelector(ApplicationContentFilter::new));
        }

        private static final class IntoLayerSpecFactory
        implements Function<String, IntoLayerSpec>,
        Serializable {
            private IntoLayerSpecFactory() {
            }

            @Override
            public IntoLayerSpec apply(String layer) {
                return new IntoLayerSpec(layer);
            }
        }
    }

    public static class DependenciesIntoLayerSpec
    extends IntoLayerSpec {
        private boolean includeProjectDependencies;
        private boolean excludeProjectDependencies;

        public DependenciesIntoLayerSpec(String intoLayer) {
            super(intoLayer);
        }

        public void includeProjectDependencies() {
            this.includeProjectDependencies = true;
        }

        public void excludeProjectDependencies() {
            this.excludeProjectDependencies = true;
        }

        ContentSelector<Library> asLibrarySelector(Function<String, ContentFilter<Library>> filterFactory) {
            Layer layer = new Layer(this.getIntoLayer());
            List includeFilters = this.getIncludes().stream().map(filterFactory).collect(Collectors.toList());
            if (this.includeProjectDependencies) {
                includeFilters = new ArrayList(includeFilters);
                includeFilters.add(Library::isLocal);
            }
            List excludeFilters = this.getExcludes().stream().map(filterFactory).collect(Collectors.toList());
            if (this.excludeProjectDependencies) {
                excludeFilters = new ArrayList(excludeFilters);
                excludeFilters.add(Library::isLocal);
            }
            return new IncludeExcludeContentSelector(layer, includeFilters, excludeFilters);
        }
    }

    public static class IntoLayerSpec
    implements Serializable {
        private final String intoLayer;
        private final List<String> includes = new ArrayList<String>();
        private final List<String> excludes = new ArrayList<String>();

        public IntoLayerSpec(String intoLayer) {
            this.intoLayer = intoLayer;
        }

        public void include(String ... patterns) {
            this.includes.addAll(Arrays.asList(patterns));
        }

        public void exclude(String ... patterns) {
            this.includes.addAll(Arrays.asList(patterns));
        }

        <T> ContentSelector<T> asSelector(Function<String, ContentFilter<T>> filterFactory) {
            Layer layer = new Layer(this.intoLayer);
            return new IncludeExcludeContentSelector(layer, this.includes, this.excludes, filterFactory);
        }

        String getIntoLayer() {
            return this.intoLayer;
        }

        List<String> getIncludes() {
            return this.includes;
        }

        List<String> getExcludes() {
            return this.excludes;
        }
    }

    public static abstract class IntoLayersSpec
    implements Serializable {
        private final List<IntoLayerSpec> intoLayers;
        private final Function<String, IntoLayerSpec> specFactory;

        boolean isEmpty() {
            return this.intoLayers.isEmpty();
        }

        IntoLayersSpec(Function<String, IntoLayerSpec> specFactory, IntoLayerSpec ... spec) {
            this.intoLayers = new ArrayList<IntoLayerSpec>(Arrays.asList(spec));
            this.specFactory = specFactory;
        }

        public void intoLayer(String layer) {
            this.intoLayers.add(this.specFactory.apply(layer));
        }

        public void intoLayer(String layer, Closure<?> closure) {
            this.intoLayer(layer, (Action<IntoLayerSpec>)ConfigureUtil.configureUsing(closure));
        }

        public void intoLayer(String layer, Action<IntoLayerSpec> action) {
            IntoLayerSpec spec = this.specFactory.apply(layer);
            action.execute((Object)spec);
            this.intoLayers.add(spec);
        }

        <T> List<ContentSelector<T>> asSelectors(Function<IntoLayerSpec, ContentSelector<T>> selectorFactory) {
            return this.intoLayers.stream().map(selectorFactory).collect(Collectors.toList());
        }
    }
}

