/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.GradleException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GradleVersion;
import org.springframework.boot.gradle.tasks.bundling.BootZipCopyAction;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.LayerResolver;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;

class BootArchiveSupport {
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private static final Set<String> DEFAULT_LAUNCHER_CLASSES;
    private final PatternSet requiresUnpack = new PatternSet();
    private final PatternSet exclusions = new PatternSet();
    private final String loaderMainClass;
    private final Spec<FileCopyDetails> librarySpec;
    private final Function<FileCopyDetails, ZipCompression> compressionResolver;
    private LaunchScriptConfiguration launchScript;

    BootArchiveSupport(String loaderMainClass, Spec<FileCopyDetails> librarySpec, Function<FileCopyDetails, ZipCompression> compressionResolver) {
        this.loaderMainClass = loaderMainClass;
        this.librarySpec = librarySpec;
        this.compressionResolver = compressionResolver;
        this.requiresUnpack.include(Specs.satisfyNone());
    }

    void configureManifest(Manifest manifest, String mainClass, String classes, String lib, String classPathIndex, String layersIndex) {
        Attributes attributes = manifest.getAttributes();
        attributes.putIfAbsent((Object)"Main-Class", (Object)this.loaderMainClass);
        attributes.putIfAbsent((Object)"Start-Class", (Object)mainClass);
        attributes.computeIfAbsent((Object)"Spring-Boot-Version", name -> this.determineSpringBootVersion());
        attributes.putIfAbsent((Object)"Spring-Boot-Classes", (Object)classes);
        attributes.putIfAbsent((Object)"Spring-Boot-Lib", (Object)lib);
        if (classPathIndex != null) {
            attributes.putIfAbsent((Object)"Spring-Boot-Classpath-Index", (Object)classPathIndex);
        }
        if (layersIndex != null) {
            attributes.putIfAbsent((Object)"Spring-Boot-Layers-Index", (Object)layersIndex);
        }
    }

    private String determineSpringBootVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version != null ? version : "unknown";
    }

    CopyAction createCopyAction(Jar jar) {
        return this.createCopyAction(jar, null, null);
    }

    CopyAction createCopyAction(Jar jar, LayerResolver layerResolver, String layerToolsLocation) {
        File output = ((RegularFile)jar.getArchiveFile().get()).getAsFile();
        Manifest manifest = jar.getManifest();
        boolean preserveFileTimestamps = jar.isPreserveFileTimestamps();
        Integer dirMode = this.getDirMode((CopySpec)jar);
        Integer fileMode = this.getFileMode((CopySpec)jar);
        boolean includeDefaultLoader = this.isUsingDefaultLoader(jar);
        Spec requiresUnpack = this.requiresUnpack.getAsSpec();
        Spec exclusions = this.exclusions.getAsExcludeSpec();
        LaunchScriptConfiguration launchScript = this.launchScript;
        Spec<FileCopyDetails> librarySpec = this.librarySpec;
        Function<FileCopyDetails, ZipCompression> compressionResolver = this.compressionResolver;
        String encoding = jar.getMetadataCharset();
        BootZipCopyAction action = new BootZipCopyAction(output, manifest, preserveFileTimestamps, dirMode, fileMode, includeDefaultLoader, layerToolsLocation, (Spec<FileTreeElement>)requiresUnpack, (Spec<FileTreeElement>)exclusions, launchScript, librarySpec, compressionResolver, encoding, layerResolver);
        return jar.isReproducibleFileOrder() ? new ReproducibleOrderingCopyAction(action) : action;
    }

    private Integer getDirMode(CopySpec copySpec) {
        return this.getMode(copySpec, "getDirPermissions", () -> ((CopySpec)copySpec).getDirMode());
    }

    private Integer getFileMode(CopySpec copySpec) {
        return this.getMode(copySpec, "getFilePermissions", () -> ((CopySpec)copySpec).getFileMode());
    }

    private Integer getMode(CopySpec copySpec, String methodName, Supplier<Integer> fallback) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.3")) >= 0) {
            try {
                Object filePermissions = ((Property)copySpec.getClass().getMethod(methodName, new Class[0]).invoke((Object)copySpec, new Object[0])).getOrNull();
                return filePermissions != null ? Integer.valueOf((Integer)filePermissions.getClass().getMethod("toUnixNumeric", new Class[0]).invoke(filePermissions, new Object[0])) : null;
            }
            catch (Exception ex) {
                throw new GradleException("Failed to get permissions", (Throwable)ex);
            }
        }
        return fallback.get();
    }

    private boolean isUsingDefaultLoader(Jar jar) {
        return DEFAULT_LAUNCHER_CLASSES.contains(jar.getManifest().getAttributes().get((Object)"Main-Class"));
    }

    LaunchScriptConfiguration getLaunchScript() {
        return this.launchScript;
    }

    void setLaunchScript(LaunchScriptConfiguration launchScript) {
        this.launchScript = launchScript;
    }

    void requiresUnpack(String ... patterns) {
        this.requiresUnpack.include(patterns);
    }

    void requiresUnpack(Spec<FileTreeElement> spec) {
        this.requiresUnpack.include(spec);
    }

    void excludeNonZipLibraryFiles(FileCopyDetails details) {
        if (this.librarySpec.isSatisfiedBy((Object)details)) {
            this.excludeNonZipFiles(details);
        }
    }

    void excludeNonZipFiles(FileCopyDetails details) {
        if (!this.isZip(details.getFile())) {
            details.exclude();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isZip(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            boolean bl = this.isZip(fileInputStream);
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private boolean isZip(InputStream inputStream) throws IOException {
        for (byte headerByte : ZIP_FILE_HEADER) {
            if (inputStream.read() == headerByte) continue;
            return false;
        }
        return true;
    }

    void moveModuleInfoToRoot(CopySpec spec) {
        spec.filesMatching("module-info.class", this::moveToRoot);
    }

    void moveToRoot(FileCopyDetails details) {
        details.setRelativePath(details.getRelativeSourcePath());
    }

    static {
        HashSet<String> defaultLauncherClasses = new HashSet<String>();
        defaultLauncherClasses.add("org.springframework.boot.loader.JarLauncher");
        defaultLauncherClasses.add("org.springframework.boot.loader.PropertiesLauncher");
        defaultLauncherClasses.add("org.springframework.boot.loader.WarLauncher");
        DEFAULT_LAUNCHER_CLASSES = Collections.unmodifiableSet(defaultLauncherClasses);
    }

    private static final class ReproducibleOrderingCopyAction
    implements CopyAction {
        private final CopyAction delegate;

        private ReproducibleOrderingCopyAction(CopyAction delegate) {
            this.delegate = delegate;
        }

        public WorkResult execute(CopyActionProcessingStream stream) {
            return this.delegate.execute(action -> {
                TreeMap detailsByPath = new TreeMap();
                stream.process(details -> detailsByPath.put(details.getRelativePath(), details));
                detailsByPath.values().forEach(arg_0 -> ((CopyActionProcessingStreamAction)action).processFile(arg_0));
            });
        }
    }
}

