/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.AioClient;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupContext;
import org.tio.client.ConnectionCompletionVo;
import org.tio.client.ReconnConf;
import org.tio.client.intf.ClientAioListener;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.intf.Packet;
import org.tio.core.utils.SystemTimer;

public class ConnectionCompletionHandler<SessionContext, P extends Packet, R>
implements CompletionHandler<Void, ConnectionCompletionVo<SessionContext, P, R>> {
    private static Logger log = LoggerFactory.getLogger(ConnectionCompletionHandler.class);

    @Override
    public void completed(Void result, ConnectionCompletionVo<SessionContext, P, R> attachment) {
        this.handler(result, attachment, null);
    }

    @Override
    public void failed(Throwable throwable, ConnectionCompletionVo<SessionContext, P, R> attachment) {
        this.handler(null, attachment, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handler(Void result, ConnectionCompletionVo<SessionContext, P, R> attachment, Throwable throwable) {
        ClientChannelContext<SessionContext, P, R> channelContext = attachment.getChannelContext();
        AsynchronousSocketChannel asynchronousSocketChannel = attachment.getAsynchronousSocketChannel();
        AioClient<SessionContext, P, R> aioClient = attachment.getAioClient();
        ClientGroupContext<SessionContext, P, R> clientGroupContext = aioClient.getClientGroupContext();
        Node serverNode = attachment.getServerNode();
        String bindIp = attachment.getBindIp();
        Integer bindPort = attachment.getBindPort();
        ClientAioListener<SessionContext, P, R> clientAioListener = clientGroupContext.getClientAioListener();
        boolean isReconnect = attachment.isReconnect();
        boolean isConnected = false;
        try {
            if (throwable == null) {
                if (isReconnect) {
                    channelContext.setAsynchronousSocketChannel(asynchronousSocketChannel);
                    channelContext.getHandlerRunnable().setCanceled(false);
                    channelContext.getSendRunnable().setCanceled(false);
                    clientGroupContext.closeds.remove(channelContext);
                } else {
                    channelContext = new ClientChannelContext<SessionContext, P, R>(clientGroupContext, asynchronousSocketChannel);
                    channelContext.setServerNode(serverNode);
                    channelContext.getStat().setTimeClosed(SystemTimer.currentTimeMillis());
                }
                channelContext.setBindIp(bindIp);
                channelContext.setBindPort(bindPort);
                channelContext.setReconnCount(0);
                channelContext.setClosed(false);
                isConnected = true;
                attachment.setChannelContext(channelContext);
                clientGroupContext.connecteds.add(channelContext);
                ReadCompletionHandler readCompletionHandler = channelContext.getReadCompletionHandler();
                ByteBuffer readByteBuffer = readCompletionHandler.getReadByteBuffer();
                readByteBuffer.position(0);
                readByteBuffer.limit(readByteBuffer.capacity());
                asynchronousSocketChannel.read(readByteBuffer, readByteBuffer, readCompletionHandler);
                log.info("connected to {}", (Object)serverNode);
                if (isConnected && !isReconnect) {
                    channelContext.getStat().setTimeFirstConnected(SystemTimer.currentTimeMillis());
                }
            } else {
                log.error(throwable.toString(), throwable);
                if (channelContext == null) {
                    channelContext = new ClientChannelContext<SessionContext, P, R>(clientGroupContext, asynchronousSocketChannel);
                    channelContext.setServerNode(serverNode);
                    channelContext.getStat().setTimeClosed(SystemTimer.currentTimeMillis());
                }
                if (!isReconnect) {
                    clientGroupContext.closeds.add(channelContext);
                }
                attachment.setChannelContext(channelContext);
                ReconnConf.put(channelContext);
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
        finally {
            if (attachment.getCountDownLatch() != null) {
                attachment.getCountDownLatch().countDown();
            }
            try {
                clientAioListener.onAfterConnected(channelContext, isConnected, isReconnect);
            }
            catch (Exception e1) {
                log.error(e1.toString(), (Throwable)e1);
            }
        }
    }
}

