/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ChannelContextFilter;
import org.tio.core.CloseRunnable;
import org.tio.core.GroupContext;
import org.tio.core.ObjWithLock;
import org.tio.core.PacketSendMode;
import org.tio.core.SynPacketAction;
import org.tio.core.intf.Packet;
import org.tio.core.intf.PacketWithMeta;
import org.tio.core.task.SendRunnable;
import org.tio.core.threadpool.SynThreadPoolExecutor;
import org.tio.core.utils.ThreadUtils;

public abstract class Aio {
    private static Logger log = LoggerFactory.getLogger(Aio.class);

    public static <SessionContext, P extends Packet, R> void bindGroup(ChannelContext<SessionContext, P, R> channelContext, String groupid) {
        channelContext.getGroupContext().groups.bind(groupid, channelContext);
    }

    public static <SessionContext, P extends Packet, R> void bindUser(ChannelContext<SessionContext, P, R> channelContext, String userid) {
        channelContext.getGroupContext().users.bind(userid, channelContext);
    }

    public static <SessionContext, P extends Packet, R> void close(ChannelContext<SessionContext, P, R> channelContext, String remark) {
        Aio.close(channelContext, null, remark);
    }

    public static <SessionContext, P extends Packet, R> void close(ChannelContext<SessionContext, P, R> channelContext, Throwable throwable, String remark) {
        Aio.close(channelContext, throwable, remark, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <SessionContext, P extends Packet, R> void close(ChannelContext<SessionContext, P, R> channelContext, Throwable throwable, String remark, boolean isNeedRemove) {
        if (channelContext.isWaitingClose()) {
            log.info("{} \u6b63\u5728\u7b49\u5f85\u88ab\u5173\u95ed", channelContext);
            return;
        }
        ChannelContext<SessionContext, P, R> channelContext2 = channelContext;
        synchronized (channelContext2) {
            if (channelContext.isWaitingClose()) {
                log.info("{} \u6b63\u5728\u7b49\u5f85\u88ab\u5173\u95ed", channelContext);
                return;
            }
            channelContext.setWaitingClose(true);
            SynThreadPoolExecutor closePoolExecutor = channelContext.getGroupContext().getTioExecutor();
            ((ThreadPoolExecutor)closePoolExecutor).execute(new CloseRunnable<SessionContext, P, R>(channelContext, throwable, remark, isNeedRemove));
        }
    }

    public static <SessionContext, P extends Packet, R> void close(GroupContext<SessionContext, P, R> groupContext, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        ChannelContext channelContext = groupContext.clientNodes.find(clientIp, clientPort);
        Aio.close(channelContext, throwable, remark);
    }

    public static <SessionContext, P extends Packet, R> ChannelContext<SessionContext, P, R> getChannelContextByClientNode(GroupContext<SessionContext, P, R> groupContext, String clientIp, Integer clientPort) {
        return groupContext.clientNodes.find(clientIp, clientPort);
    }

    public static ChannelContext<?, ?, ?> getChannelContextById(String id) {
        return GroupContext.ids.find(id);
    }

    public static <SessionContext, P extends Packet, R> ChannelContext<SessionContext, P, R> getChannelContextByUserid(GroupContext<SessionContext, P, R> groupContext, String userid) {
        return groupContext.users.find(userid);
    }

    public static <SessionContext, P extends Packet, R> ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> getChannelContextsByGroup(GroupContext<SessionContext, P, R> groupContext, String groupid) {
        return groupContext.groups.clients(groupid);
    }

    public static <SessionContext, P extends Packet, R> void remove(ChannelContext<SessionContext, P, R> channelContext, String remark) {
        Aio.remove(channelContext, null, remark);
    }

    public static <SessionContext, P extends Packet, R> void remove(ChannelContext<SessionContext, P, R> channelContext, Throwable throwable, String remark) {
        Aio.close(channelContext, throwable, remark, true);
    }

    public static <SessionContext, P extends Packet, R> void remove(GroupContext<SessionContext, P, R> groupContext, String clientIp, Integer clientPort, Throwable throwable, String remark) {
        ChannelContext channelContext = groupContext.clientNodes.find(clientIp, clientPort);
        Aio.remove(channelContext, throwable, remark);
    }

    public static <SessionContext, P extends Packet, R> void send(ChannelContext<SessionContext, P, R> channelContext, P packet) {
        Aio.send(channelContext, packet, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <SessionContext, P extends Packet, R> Boolean send(ChannelContext<SessionContext, P, R> channelContext, P packet, CountDownLatch countDownLatch, PacketSendMode packetSendMode) {
        block14: {
            Boolean isSentSuccess;
            PacketWithMeta<P> packetWithMeta;
            SendRunnable<SessionContext, P, R> sendRunnable;
            boolean isSingleBlock;
            block13: {
                if (channelContext.isClosed() || channelContext.isRemoved()) {
                    log.error("{}, isClosed:{}, isRemoved:{}, stack:{} ", new Object[]{channelContext, channelContext.isClosed(), channelContext.isRemoved(), ThreadUtils.stackTrace()});
                    return false;
                }
                isSingleBlock = countDownLatch != null && packetSendMode == PacketSendMode.SINGLE_BLOCK;
                sendRunnable = channelContext.getSendRunnable();
                packetWithMeta = null;
                boolean isAdded = false;
                if (countDownLatch == null) {
                    isAdded = sendRunnable.addMsg(packet);
                } else {
                    packetWithMeta = new PacketWithMeta<P>(packet, countDownLatch);
                    isAdded = sendRunnable.addMsg(packetWithMeta);
                }
                if (isAdded) break block13;
                if (countDownLatch != null) {
                    countDownLatch.countDown();
                }
                Boolean bl = false;
                return bl;
            }
            channelContext.getGroupContext().getTioExecutor().execute(sendRunnable);
            if (!isSingleBlock) break block14;
            long timeout = 10L;
            try {
                channelContext.traceSynPacket(SynPacketAction.BEFORE_WAIT, packet, countDownLatch, null);
                Boolean awaitFlag = countDownLatch.await(timeout, TimeUnit.SECONDS);
                channelContext.traceSynPacket(SynPacketAction.AFTER__WAIT, packet, countDownLatch, null);
                if (!awaitFlag.booleanValue()) {
                    log.error("{} \u540c\u6b65\u53d1\u9001\u8d85\u65f6, timeout:{}s, packet:{}", new Object[]{channelContext, timeout, packet.logstr()});
                }
            }
            catch (InterruptedException e) {
                log.error(e.toString(), (Throwable)e);
            }
            Boolean bl = isSentSuccess = packetWithMeta.getIsSentSuccess();
            return bl;
        }
        try {
            Boolean bl = null;
            return bl;
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            Boolean bl = null;
            return bl;
        }
    }

    public static <SessionContext, P extends Packet, R> void send(GroupContext<SessionContext, P, R> groupContext, String ip, int port, P packet) {
        Aio.send(groupContext, ip, port, packet, false);
    }

    private static <SessionContext, P extends Packet, R> Boolean send(GroupContext<SessionContext, P, R> groupContext, String ip, int port, P packet, boolean isSyn) {
        ChannelContext channelContext = groupContext.clientNodes.find(ip, port);
        if (channelContext != null) {
            Aio.send(channelContext, packet);
            return null;
        }
        log.error("can find channelContext by {}:{}", (Object)ip, (Object)port);
        return false;
    }

    public static <SessionContext, P extends Packet, R> void sendToAll(GroupContext<SessionContext, P, R> groupContext, P packet, ChannelContextFilter<SessionContext, P, R> channelContextFilter) {
        Aio.sendToAll(groupContext, packet, channelContextFilter, false);
    }

    private static <SessionContext, P extends Packet, R> Boolean sendToAll(GroupContext<SessionContext, P, R> groupContext, P packet, ChannelContextFilter<SessionContext, P, R> channelContextFilter, boolean isSyn) {
        ObjWithLock setWithLock = groupContext.connections.getSetWithLock();
        if (setWithLock == null) {
            log.debug("\u6ca1\u6709\u4efb\u4f55\u8fde\u63a5");
            return false;
        }
        return Aio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, isSyn);
    }

    public static <SessionContext, P extends Packet, R> void sendToGroup(GroupContext<SessionContext, P, R> groupContext, String groupid, P packet) {
        Aio.sendToGroup(groupContext, groupid, packet, null);
    }

    public static <SessionContext, P extends Packet, R> void sendToGroup(GroupContext<SessionContext, P, R> groupContext, String groupid, P packet, ChannelContextFilter<SessionContext, P, R> channelContextFilter) {
        Aio.sendToGroup(groupContext, groupid, packet, channelContextFilter, false);
    }

    private static <SessionContext, P extends Packet, R> Boolean sendToGroup(GroupContext<SessionContext, P, R> groupContext, String groupid, P packet, ChannelContextFilter<SessionContext, P, R> channelContextFilter, boolean isSyn) {
        ObjWithLock setWithLock = groupContext.groups.clients(groupid);
        if (setWithLock == null) {
            log.error("\u7ec4[{}]\u4e0d\u5b58\u5728", (Object)groupid);
            return false;
        }
        return Aio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, isSyn);
    }

    public static <SessionContext, P extends Packet, R> void sendToSet(GroupContext<SessionContext, P, R> groupContext, ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> setWithLock, P packet, ChannelContextFilter<SessionContext, P, R> channelContextFilter) {
        Aio.sendToSet(groupContext, setWithLock, packet, channelContextFilter, false);
    }

    /*
     * Exception decompiling
     */
    private static <SessionContext, P extends Packet, R> Boolean sendToSet(GroupContext<SessionContext, P, R> groupContext, ObjWithLock<Set<ChannelContext<SessionContext, P, R>>> setWithLock, P packet, ChannelContextFilter<SessionContext, P, R> channelContextFilter, boolean isSyn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 8[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <SessionContext, P extends Packet, R> void sendToUser(GroupContext<SessionContext, P, R> groupContext, String userid, P packet) {
        Aio.sendToUser(groupContext, userid, packet, false);
    }

    private static <SessionContext, P extends Packet, R> Boolean sendToUser(GroupContext<SessionContext, P, R> groupContext, String userid, P packet, boolean isSyn) {
        ChannelContext channelContext = groupContext.users.find(userid);
        Aio.send(channelContext, packet);
        return null;
    }

    public static <SessionContext, P extends Packet, R> void unbindGroup(ChannelContext<SessionContext, P, R> channelContext) {
        channelContext.getGroupContext().groups.unbind(channelContext);
    }

    public static <SessionContext, P extends Packet, R> void unbindGroup(String group, ChannelContext<SessionContext, P, R> channelContext) {
        channelContext.getGroupContext().groups.unbind(group, channelContext);
    }

    public static <SessionContext, P extends Packet, R> void unbindUser(ChannelContext<SessionContext, P, R> channelContext) {
        channelContext.getGroupContext().users.unbind(channelContext);
    }
}

