/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import com.xiaoleilu.hutool.date.DatePattern;
import com.xiaoleilu.hutool.date.DateTime;
import com.xiaoleilu.hutool.date.format.DatePrinter;
import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.tio.core.ChannelStat;
import org.tio.core.ClientAction;
import org.tio.core.GroupContext;
import org.tio.core.Node;
import org.tio.core.ReadCompletionHandler;
import org.tio.core.SynPacketAction;
import org.tio.core.WriteCompletionHandler;
import org.tio.core.intf.Packet;
import org.tio.core.intf.PacketWithMeta;
import org.tio.core.task.DecodeRunnable;
import org.tio.core.task.HandlerRunnable;
import org.tio.core.task.SendRunnable;
import org.tio.json.Json;

public abstract class ChannelContext<SessionContext, P extends Packet, R> {
    private static Logger log = LoggerFactory.getLogger(ChannelContext.class);
    private boolean isTraceClient = false;
    private boolean isTraceSynPacket = false;
    public static final String UNKNOWN_ADDRESS_IP = "$UNKNOWN";
    public static final AtomicInteger UNKNOWN_ADDRESS_PORT_SEQ = new AtomicInteger();
    private GroupContext<SessionContext, P, R> groupContext = null;
    private DecodeRunnable<SessionContext, P, R> decodeRunnable = null;
    private HandlerRunnable<SessionContext, P, R> handlerRunnable = null;
    private SendRunnable<SessionContext, P, R> sendRunnable = null;
    private ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private ReadCompletionHandler<SessionContext, P, R> readCompletionHandler = null;
    private WriteCompletionHandler<SessionContext, P, R> writeCompletionHandler = null;
    private int reconnCount = 0;
    private String userid;
    private boolean isWaitingClose = false;
    private boolean isClosed = true;
    private boolean isRemoved = false;
    private ChannelStat stat = new ChannelStat();
    private AsynchronousSocketChannel asynchronousSocketChannel;
    private SessionContext sessionContext;
    private String id = null;
    private Node clientNode;
    private String clientNodeTraceFilename;
    private Node serverNode;
    private Logger traceSynPacketLog = LoggerFactory.getLogger((String)"tio-client-trace-syn-log");

    public ChannelContext(GroupContext<SessionContext, P, R> groupContext, AsynchronousSocketChannel asynchronousSocketChannel) {
        this.id = UUID.randomUUID().toString();
        GroupContext.ids.bind(this);
        this.setGroupContext(groupContext);
        this.setAsynchronousSocketChannel(asynchronousSocketChannel);
        this.readCompletionHandler = new ReadCompletionHandler(this);
        this.writeCompletionHandler = new WriteCompletionHandler(this);
    }

    public abstract Node createClientNode(AsynchronousSocketChannel var1) throws IOException;

    public String toString() {
        return this.getClientNode().toString();
    }

    public AsynchronousSocketChannel getAsynchronousSocketChannel() {
        return this.asynchronousSocketChannel;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public String getId() {
        return this.id;
    }

    public Node getClientNode() {
        return this.clientNode;
    }

    public void setAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
        this.asynchronousSocketChannel = asynchronousSocketChannel;
        if (asynchronousSocketChannel != null) {
            try {
                Node clientNode = this.createClientNode(asynchronousSocketChannel);
                this.setClientNode(clientNode);
            }
            catch (IOException e) {
                log.info(e.toString(), (Throwable)e);
                this.assignAnUnknownClientNode();
            }
        } else {
            this.assignAnUnknownClientNode();
        }
    }

    private void assignAnUnknownClientNode() {
        Node clientNode = new Node(UNKNOWN_ADDRESS_IP, UNKNOWN_ADDRESS_PORT_SEQ.incrementAndGet());
        this.setClientNode(clientNode);
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    private void setClientNode(Node clientNode) {
        if (this.clientNode != null) {
            try {
                this.groupContext.clientNodes.remove(this);
            }
            catch (Exception e1) {
                log.error(e1.toString(), (Throwable)e1);
            }
        }
        this.clientNode = clientNode;
        if (this.clientNode != null && !Objects.equals(UNKNOWN_ADDRESS_IP, this.clientNode.getIp())) {
            try {
                this.groupContext.clientNodes.put(this);
            }
            catch (Exception e1) {
                log.error(e1.toString(), (Throwable)e1);
            }
        }
        this.clientNodeTraceFilename = StringUtils.replaceAll((String)clientNode.toString(), (String)":", (String)"_");
    }

    public GroupContext<SessionContext, P, R> getGroupContext() {
        return this.groupContext;
    }

    public void setGroupContext(GroupContext<SessionContext, P, R> groupContext) {
        this.groupContext = groupContext;
        if (groupContext != null) {
            this.decodeRunnable = new DecodeRunnable(this);
            this.handlerRunnable = new HandlerRunnable(this, groupContext.getTioExecutor());
            this.sendRunnable = new SendRunnable(this, groupContext.getTioExecutor());
            groupContext.connections.add(this);
        }
    }

    public ReadCompletionHandler<SessionContext, P, R> getReadCompletionHandler() {
        return this.readCompletionHandler;
    }

    public DecodeRunnable<SessionContext, P, R> getDecodeRunnable() {
        return this.decodeRunnable;
    }

    public HandlerRunnable<SessionContext, P, R> getHandlerRunnable() {
        return this.handlerRunnable;
    }

    public SendRunnable<SessionContext, P, R> getSendRunnable() {
        return this.sendRunnable;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
        if (isClosed && (this.clientNode == null || !UNKNOWN_ADDRESS_IP.equals(this.clientNode.getIp()))) {
            String before = this.toString();
            this.assignAnUnknownClientNode();
            log.info("\u5173\u95ed\u524d{}, \u5173\u95ed\u540e{}", (Object)before, (Object)this);
        }
    }

    public ChannelStat getStat() {
        return this.stat;
    }

    public WriteCompletionHandler<SessionContext, P, R> getWriteCompletionHandler() {
        return this.writeCompletionHandler;
    }

    public int getReconnCount() {
        return this.reconnCount;
    }

    public void setReconnCount(int reconnCount) {
        this.reconnCount = reconnCount;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public void setServerNode(Node serverNode) {
        this.serverNode = serverNode;
    }

    public ReentrantReadWriteLock getCloseLock() {
        return this.closeLock;
    }

    public boolean isWaitingClose() {
        return this.isWaitingClose;
    }

    public void setWaitingClose(boolean isWaitingClose) {
        this.isWaitingClose = isWaitingClose;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void traceClient(ClientAction clientAction, Packet packet, Map<String, Object> extmsg) {
        if (this.isTraceClient) {
            this.getGroupContext().getClientTraceHandler().traceClient(this, clientAction, packet, extmsg);
        }
    }

    public void traceSynPacket(SynPacketAction synPacketAction, Packet packet, CountDownLatch countDownLatch, Map<String, Object> extmsg) {
        if (this.isTraceSynPacket) {
            ChannelContext channelContext = this;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("time", DateTime.now().toString((DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT));
            map.put("c_id", channelContext.getId());
            map.put("c", channelContext.toString());
            map.put("action", (Object)synPacketAction);
            MDC.put((String)"tio_client_syn", (String)channelContext.getClientNodeTraceFilename());
            if (packet != null) {
                map.put("p_id", channelContext.getClientNode().getPort() + "_" + packet.getId());
                map.put("p_respId", packet.getRespId());
                map.put("packet", packet.logstr());
            }
            if (countDownLatch != null) {
                map.put("countDownLatch", countDownLatch.hashCode() + " " + countDownLatch.getCount());
            }
            if (extmsg != null) {
                map.putAll(extmsg);
            }
            String logstr = Json.toJson(map);
            this.traceSynPacketLog.info(logstr);
            log.error(logstr);
        }
    }

    public boolean isTraceClient() {
        return this.isTraceClient;
    }

    public void setTraceClient(boolean isTraceClient) {
        this.isTraceClient = isTraceClient;
    }

    public String getClientNodeTraceFilename() {
        return this.clientNodeTraceFilename;
    }

    public void setClientNodeTraceFilename(String clientNodeTraceFilename) {
        this.clientNodeTraceFilename = clientNodeTraceFilename;
    }

    public void processAfterSent(Object obj, Boolean isSentSuccess) {
        Packet packet = null;
        PacketWithMeta packetWithMeta = null;
        boolean isPacket = obj instanceof Packet;
        if (isPacket) {
            packet = (Packet)obj;
        } else {
            packetWithMeta = (PacketWithMeta)obj;
            packet = packetWithMeta.getPacket();
            CountDownLatch countDownLatch = packetWithMeta.getCountDownLatch();
            this.traceSynPacket(SynPacketAction.BEFORE_DOWN, packet, countDownLatch, null);
            countDownLatch.countDown();
        }
        try {
            this.groupContext.getAioListener().onAfterSent(this, packet, isSentSuccess == null ? false : isSentSuccess);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public boolean isTraceSynPacket() {
        return this.isTraceSynPacket;
    }

    public void setTraceSynPacket(boolean isTraceSynPacket) {
        this.isTraceSynPacket = isTraceSynPacket;
    }
}

