/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import com.xiaoleilu.hutool.date.DatePattern;
import com.xiaoleilu.hutool.date.DateTime;
import com.xiaoleilu.hutool.date.format.DatePrinter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.tio.core.ChannelContext;
import org.tio.core.ClientAction;
import org.tio.core.intf.ClientTraceHandler;
import org.tio.core.intf.Packet;
import org.tio.json.Json;

public class DefaultClientTraceHandler<SessionContext, P extends Packet, R>
implements ClientTraceHandler<SessionContext, P, R> {
    private Logger clientTraceLog = LoggerFactory.getLogger((String)"tio-client-trace-log");

    @Override
    public void traceClient(ChannelContext<SessionContext, P, R> channelContext, ClientAction clientAction, Packet packet, Map<String, Object> extmsg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("time", DateTime.now().toString((DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT));
        map.put("action", (Object)clientAction);
        map.put("c_id", channelContext.getId());
        map.put("c", channelContext.toString());
        MDC.put((String)"tio_client", (String)channelContext.getClientNodeTraceFilename());
        if (packet != null) {
            map.put("p_id", channelContext.getClientNode().getPort() + "_" + packet.getId());
            map.put("p_respId", packet.getRespId());
            map.put("packet", packet.logstr());
        }
        if (extmsg != null) {
            map.putAll(extmsg);
        }
        this.clientTraceLog.info(Json.toJson(map));
    }
}

