/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteOrder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ReconnConf;
import org.tio.core.DefaultClientTraceHandler;
import org.tio.core.PacketHandlerMode;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.ClientTraceHandler;
import org.tio.core.intf.Packet;
import org.tio.core.maintain.ChannelContextMapWithLock;
import org.tio.core.maintain.ChannelContextSetWithLock;
import org.tio.core.maintain.ClientNodes;
import org.tio.core.maintain.Groups;
import org.tio.core.maintain.Ids;
import org.tio.core.maintain.Users;
import org.tio.core.stat.GroupStat;
import org.tio.core.threadpool.DefaultThreadFactory;
import org.tio.core.threadpool.SynThreadPoolExecutor;

public abstract class GroupContext<SessionContext, P extends Packet, R> {
    static Logger log = LoggerFactory.getLogger(GroupContext.class);
    private static int CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 1;
    private static final int MAX_POOL_SIZE = CORE_POOL_SIZE * 2 < 256 ? 256 : CORE_POOL_SIZE * 2;
    public static final int READ_BUFFER_SIZE = Integer.getInteger("tio.default.read.buffer.size", 2048);
    public static final long KEEP_ALIVE_TIME = 90L;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected long heartbeatTimeout = 120000L;
    private PacketHandlerMode packetHandlerMode = PacketHandlerMode.SINGLE_THREAD;
    protected int readBufferSize = READ_BUFFER_SIZE;
    protected ReconnConf<SessionContext, P, R> reconnConf;
    private ClientTraceHandler<SessionContext, P, R> clientTraceHandler = new DefaultClientTraceHandler();
    protected SynThreadPoolExecutor tioExecutor = null;
    protected ThreadPoolExecutor groupExecutor = null;
    public final ClientNodes<SessionContext, P, R> clientNodes = new ClientNodes();
    public final ChannelContextSetWithLock<SessionContext, P, R> connections = new ChannelContextSetWithLock();
    public final ChannelContextSetWithLock<SessionContext, P, R> connecteds = new ChannelContextSetWithLock();
    public final ChannelContextSetWithLock<SessionContext, P, R> closeds = new ChannelContextSetWithLock();
    public final Groups<SessionContext, P, R> groups = new Groups();
    public final Users<SessionContext, P, R> users = new Users();
    public static final Ids<?, ?, ?> ids = new Ids();
    public final ChannelContextMapWithLock<SessionContext, P, R> waitingResps = new ChannelContextMapWithLock();
    private boolean isEncodeCareWithChannelContext = true;
    protected String id = ID_ATOMIC.incrementAndGet() + "";
    private boolean isStopped = false;
    private static final AtomicInteger ID_ATOMIC = new AtomicInteger();

    public GroupContext() {
        LinkedBlockingQueue<Runnable> tioQueue = new LinkedBlockingQueue<Runnable>();
        String tioThreadName = "tio";
        this.tioExecutor = new SynThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 90L, tioQueue, DefaultThreadFactory.getInstance(tioThreadName, 5), tioThreadName);
        this.tioExecutor.prestartAllCoreThreads();
        LinkedBlockingQueue<Runnable> groupQueue = new LinkedBlockingQueue<Runnable>();
        String groupThreadName = "tio-group";
        this.groupExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 90L, TimeUnit.SECONDS, groupQueue, DefaultThreadFactory.getInstance(groupThreadName, 5));
        this.groupExecutor.prestartAllCoreThreads();
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String getId() {
        return this.id;
    }

    public long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public void setHeartbeatTimeout(long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public abstract AioHandler<SessionContext, P, R> getAioHandler();

    public abstract GroupStat getGroupStat();

    public abstract AioListener<SessionContext, P, R> getAioListener();

    public ReconnConf<SessionContext, P, R> getReconnConf() {
        return this.reconnConf;
    }

    public ChannelContextMapWithLock<SessionContext, P, R> getWaitingResps() {
        return this.waitingResps;
    }

    public boolean isEncodeCareWithChannelContext() {
        return this.isEncodeCareWithChannelContext;
    }

    public void setEncodeCareWithChannelContext(boolean isEncodeCareWithChannelContext) {
        this.isEncodeCareWithChannelContext = isEncodeCareWithChannelContext;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public PacketHandlerMode getPacketHandlerMode() {
        return this.packetHandlerMode;
    }

    public void setPacketHandlerMode(PacketHandlerMode packetHandlerMode) {
        this.packetHandlerMode = packetHandlerMode;
    }

    public SynThreadPoolExecutor getTioExecutor() {
        return this.tioExecutor;
    }

    public ThreadPoolExecutor getGroupExecutor() {
        return this.groupExecutor;
    }

    public ClientTraceHandler<SessionContext, P, R> getClientTraceHandler() {
        return this.clientTraceHandler;
    }

    public void setClientTraceHandler(ClientTraceHandler<SessionContext, P, R> clientTraceHandler) {
        this.clientTraceHandler = clientTraceHandler;
    }
}

