/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.channels.CompletionHandler;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.ClientAction;
import org.tio.core.GroupContext;
import org.tio.core.intf.Packet;
import org.tio.core.intf.PacketWithMeta;
import org.tio.core.stat.GroupStat;

public class WriteCompletionHandler<SessionContext, P extends Packet, R>
implements CompletionHandler<Integer, Object> {
    private static Logger log = LoggerFactory.getLogger(WriteCompletionHandler.class);
    private ChannelContext<SessionContext, P, R> channelContext = null;
    private Semaphore writeSemaphore = new Semaphore(1);

    public WriteCompletionHandler(ChannelContext<SessionContext, P, R> channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public void completed(Integer result, Object attachment) {
        this.handle(result, null, attachment);
    }

    @Override
    public void failed(Throwable throwable, Object attachment) {
        this.handle(0, throwable, attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Integer result, Throwable throwable, Object attachment) {
        boolean isSentSuccess;
        this.writeSemaphore.release();
        GroupContext<SessionContext, P, R> groupContext = this.channelContext.getGroupContext();
        GroupStat groupStat = groupContext.getGroupStat();
        boolean bl = isSentSuccess = result > 0;
        if (isSentSuccess) {
            groupStat.getSentBytes().addAndGet(result.intValue());
        }
        int packetCount = 0;
        try {
            boolean isPacketWithMeta;
            boolean isPacket = attachment instanceof Packet;
            boolean bl2 = isPacketWithMeta = !isPacket && attachment instanceof PacketWithMeta;
            if (isPacket || isPacketWithMeta) {
                if (isSentSuccess) {
                    groupStat.getSentPacket().incrementAndGet();
                }
                this.handleOne(result, throwable, attachment, isSentSuccess);
            } else {
                List ps = (List)attachment;
                if (isSentSuccess) {
                    packetCount = ps.size();
                    groupStat.getSentPacket().addAndGet(packetCount);
                }
                for (Object obj : ps) {
                    this.handleOne(result, throwable, obj, isSentSuccess);
                }
            }
            if (!isSentSuccess) {
                Aio.close(this.channelContext, throwable, "\u5199\u6570\u636e\u8fd4\u56de:" + result);
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public void handleOne(Integer result, Throwable throwable, Object obj, Boolean isSentSuccess) {
        Packet packet = null;
        PacketWithMeta packetWithMeta = null;
        boolean isPacket = obj instanceof Packet;
        if (isPacket) {
            packet = (Packet)obj;
        } else {
            packetWithMeta = (PacketWithMeta)obj;
            packetWithMeta.setIsSentSuccess(isSentSuccess);
            packet = packetWithMeta.getPacket();
        }
        try {
            this.channelContext.traceClient(ClientAction.AFTER_SEND, packet, null);
            this.channelContext.processAfterSent(obj, isSentSuccess);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public Semaphore getWriteSemaphore() {
        return this.writeSemaphore;
    }
}

