/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.ObjWithLock;
import org.tio.core.intf.Packet;

public class ClientNodes<SessionContext, P extends Packet, R> {
    private ObjWithLock<DualHashBidiMap<String, ChannelContext<SessionContext, P, R>>> map = new ObjWithLock<DualHashBidiMap>(new DualHashBidiMap());

    public static <SessionContext, P extends Packet, R> String getKey(ChannelContext<SessionContext, P, R> channelContext) {
        Node clientNode = channelContext.getClientNode();
        if (clientNode == null) {
            throw new RuntimeException("client node is null");
        }
        String key = ClientNodes.getKey(clientNode.getIp(), clientNode.getPort());
        return key;
    }

    public static String getKey(String ip, int port) {
        String key = ip + ":" + port;
        return key;
    }

    public void remove(ChannelContext<SessionContext, P, R> channelContext) {
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        DualHashBidiMap<String, ChannelContext<SessionContext, P, R>> m = this.map.getObj();
        try {
            lock.lock();
            m.removeValue(channelContext);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public void put(ChannelContext<SessionContext, P, R> channelContext) {
        String key = ClientNodes.getKey(channelContext);
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        DualHashBidiMap<String, ChannelContext<SessionContext, P, R>> m = this.map.getObj();
        try {
            lock.lock();
            m.put((Object)key, channelContext);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ChannelContext<SessionContext, P, R> find(String ip, int port) {
        String key = ClientNodes.getKey(ip, port);
        return this.find(key);
    }

    public ChannelContext<SessionContext, P, R> find(String key) {
        ReentrantReadWriteLock.ReadLock lock = this.map.getLock().readLock();
        DualHashBidiMap<String, ChannelContext<SessionContext, P, R>> m = this.map.getObj();
        try {
            lock.lock();
            ChannelContext channelContext = (ChannelContext)m.get((Object)key);
            return channelContext;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ObjWithLock<DualHashBidiMap<String, ChannelContext<SessionContext, P, R>>> getMap() {
        return this.map;
    }
}

