/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.maintain;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.tio.core.ChannelContext;
import org.tio.core.ObjWithLock;
import org.tio.core.intf.Packet;

public class Users<SessionContext, P extends Packet, R> {
    private ObjWithLock<DualHashBidiMap<String, ChannelContext<SessionContext, P, R>>> map = new ObjWithLock<DualHashBidiMap>(new DualHashBidiMap());

    public ObjWithLock<DualHashBidiMap<String, ChannelContext<SessionContext, P, R>>> getMap() {
        return this.map;
    }

    public void unbind(ChannelContext<SessionContext, P, R> channelContext) {
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        DualHashBidiMap<String, ChannelContext<SessionContext, P, R>> m = this.map.getObj();
        try {
            lock.lock();
            m.removeValue(channelContext);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public void unbind(String userid) {
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        DualHashBidiMap<String, ChannelContext<SessionContext, P, R>> m = this.map.getObj();
        try {
            lock.lock();
            m.remove((Object)userid);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public void bind(String userid, ChannelContext<SessionContext, P, R> channelContext) {
        String key = userid;
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock().writeLock();
        DualHashBidiMap<String, ChannelContext<SessionContext, P, R>> m = this.map.getObj();
        try {
            lock.lock();
            m.put((Object)key, channelContext);
            channelContext.setUserid(userid);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public ChannelContext<SessionContext, P, R> find(String userid) {
        String key = userid;
        ReentrantReadWriteLock.ReadLock lock = this.map.getLock().readLock();
        DualHashBidiMap<String, ChannelContext<SessionContext, P, R>> m = this.map.getObj();
        try {
            lock.lock();
            ChannelContext channelContext = (ChannelContext)m.get((Object)key);
            return channelContext;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            lock.unlock();
        }
    }
}

