/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.ClientAction;
import org.tio.core.GroupContext;
import org.tio.core.PacketHandlerMode;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.Packet;
import org.tio.core.task.HandlerRunnable;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.core.utils.SystemTimer;

public class DecodeRunnable<SessionContext, P extends Packet, R>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DecodeRunnable.class);
    private ChannelContext<SessionContext, P, R> channelContext = null;
    private ByteBuffer lastByteBuffer = null;
    private ByteBuffer newByteBuffer = null;

    public DecodeRunnable(ChannelContext<SessionContext, P, R> channelContext) {
        this.channelContext = channelContext;
    }

    public void clearMsgQueue() {
        this.lastByteBuffer = null;
        this.newByteBuffer = null;
    }

    public static <SessionContext, P extends Packet, R> void handler(ChannelContext<SessionContext, P, R> channelContext, P packet, int byteCount) {
        GroupContext<SessionContext, P, R> groupContext = channelContext.getGroupContext();
        PacketHandlerMode packetHandlerMode = groupContext.getPacketHandlerMode();
        HandlerRunnable<SessionContext, P, R> handlerRunnable = channelContext.getHandlerRunnable();
        if (packetHandlerMode == PacketHandlerMode.QUEUE) {
            handlerRunnable.addMsg(packet);
            groupContext.getTioExecutor().execute(handlerRunnable);
        } else {
            handlerRunnable.handler(packet);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.channelContext.toString();
    }

    @Override
    public void run() {
        ByteBuffer byteBuffer = this.newByteBuffer;
        if (byteBuffer != null) {
            if (this.lastByteBuffer != null) {
                byteBuffer = ByteBufferUtils.composite(this.lastByteBuffer, byteBuffer);
                this.lastByteBuffer = null;
            }
        } else {
            return;
        }
        try {
            while (true) {
                int initPosition = byteBuffer.position();
                P packet = this.channelContext.getGroupContext().getAioHandler().decode(byteBuffer, this.channelContext);
                if (packet == null) {
                    this.lastByteBuffer = ByteBufferUtils.copy(byteBuffer, initPosition, byteBuffer.limit());
                    return;
                }
                this.channelContext.getStat().setLatestTimeOfReceivedPacket(SystemTimer.currentTimeMillis());
                int afterDecodePosition = byteBuffer.position();
                int len = afterDecodePosition - initPosition;
                this.channelContext.getGroupContext().getGroupStat().getReceivedPacket().incrementAndGet();
                this.channelContext.getGroupContext().getGroupStat().getReceivedBytes().addAndGet(len);
                this.channelContext.traceClient(ClientAction.RECEIVED, (Packet)packet, null);
                DecodeRunnable.handler(this.channelContext, packet, len);
                AioListener<SessionContext, P, R> aioListener = this.channelContext.getGroupContext().getAioListener();
                try {
                    if (log.isInfoEnabled()) {
                        log.info("{} \u6536\u5230\u6d88\u606f {}", this.channelContext, (Object)((Packet)packet).logstr());
                    }
                    aioListener.onAfterReceived(this.channelContext, packet, len);
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
                int remainingLength = byteBuffer.limit() - byteBuffer.position();
                if (remainingLength <= 0) break;
                if (!log.isDebugEnabled()) continue;
                log.debug("{},\u7ec4\u5305\u540e\uff0c\u8fd8\u5269\u6709\u6570\u636e:{}", this.channelContext, (Object)remainingLength);
            }
            this.lastByteBuffer = null;
            log.debug("{},\u7ec4\u5305\u540e\uff0c\u6570\u636e\u521a\u597d\u7528\u5b8c", this.channelContext);
            return;
        }
        catch (AioDecodeException e) {
            log.error(this.channelContext.toString() + "\u89e3\u7801\u5f02\u5e38", (Throwable)e);
            Aio.close(this.channelContext, e, "\u89e3\u7801\u5f02\u5e38:" + e.getMessage());
            return;
        }
    }

    public void setNewByteBuffer(ByteBuffer newByteBuffer) {
        this.newByteBuffer = newByteBuffer;
    }
}

