/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.ClientAction;
import org.tio.core.GroupContext;
import org.tio.core.WriteCompletionHandler;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.Packet;
import org.tio.core.intf.PacketWithMeta;
import org.tio.core.threadpool.AbstractQueueRunnable;
import org.tio.core.utils.AioUtils;
import org.tio.core.utils.SystemTimer;

public class SendRunnable<SessionContext, P extends Packet, R>
extends AbstractQueueRunnable<Object> {
    private static final Logger log = LoggerFactory.getLogger(SendRunnable.class);
    private ChannelContext<SessionContext, P, R> channelContext = null;

    public SendRunnable(ChannelContext<SessionContext, P, R> channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
    }

    @Override
    public void clearMsgQueue() {
        Object p = null;
        while (true) {
            Object e = this.msgQueue.poll();
            p = e;
            if (e == null) break;
            try {
                this.channelContext.processAfterSent(p, false);
            }
            catch (Exception e2) {
                log.error(e2.toString(), (Throwable)e2);
            }
        }
    }

    public void sendPacket(Object obj) {
        Packet packet = null;
        PacketWithMeta packetWithMeta = null;
        boolean isPacket = obj instanceof Packet;
        if (isPacket) {
            packet = (Packet)obj;
        } else {
            packetWithMeta = (PacketWithMeta)obj;
            packet = packetWithMeta.getPacket();
        }
        this.channelContext.traceClient(ClientAction.BEFORE_SEND, packet, null);
        GroupContext<SessionContext, P, R> groupContext = this.channelContext.getGroupContext();
        ByteBuffer byteBuffer = this.getByteBuffer(packet, groupContext, groupContext.getAioHandler());
        int packetCount = 1;
        if (isPacket) {
            this.sendByteBuffer(byteBuffer, packetCount, packet);
        } else {
            this.sendByteBuffer(byteBuffer, packetCount, packetWithMeta);
        }
    }

    @Override
    public boolean addMsg(Object obj) {
        if (this.isCanceled()) {
            log.error("{}, \u4efb\u52a1\u5df2\u7ecf\u53d6\u6d88\uff0c{}\u6dfb\u52a0\u5230\u53d1\u9001\u961f\u5217\u5931\u8d25", this.channelContext, obj);
            return false;
        }
        return this.msgQueue.add(obj);
    }

    public void sendByteBuffer(ByteBuffer byteBuffer, Integer packetCount, Object packets) {
        if (byteBuffer == null) {
            log.error("{},byteBuffer is null", this.channelContext);
            return;
        }
        if (!AioUtils.checkBeforeIO(this.channelContext)) {
            return;
        }
        byteBuffer.flip();
        AsynchronousSocketChannel asynchronousSocketChannel = this.channelContext.getAsynchronousSocketChannel();
        WriteCompletionHandler<SessionContext, P, R> writeCompletionHandler = this.channelContext.getWriteCompletionHandler();
        try {
            writeCompletionHandler.getWriteSemaphore().acquire();
        }
        catch (InterruptedException e) {
            log.error(e.toString(), (Throwable)e);
        }
        asynchronousSocketChannel.write(byteBuffer, packets, writeCompletionHandler);
        this.channelContext.getStat().setLatestTimeOfSentPacket(SystemTimer.currentTimeMillis());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.channelContext.toString();
    }

    @Override
    public void runTask() {
        int queueSize = this.msgQueue.size();
        if (queueSize == 0) {
            return;
        }
        if (queueSize >= 2000) {
            queueSize = 1000;
        }
        Object obj = null;
        Packet p = null;
        PacketWithMeta packetWithMeta = null;
        GroupContext<SessionContext, P, R> groupContext = this.channelContext.getGroupContext();
        AioHandler<SessionContext, P, R> aioHandler = groupContext.getAioHandler();
        if (queueSize > 1) {
            ByteBuffer[] byteBuffers = new ByteBuffer[queueSize];
            int allBytebufferCapacity = 0;
            int packetCount = 0;
            ArrayList<Object> packets = new ArrayList<Object>(queueSize);
            for (int i = 0; i < queueSize; ++i) {
                Object e = this.msgQueue.poll();
                obj = e;
                if (e == null) break;
                boolean isPacket = obj instanceof Packet;
                if (isPacket) {
                    p = obj;
                    packets.add(p);
                } else {
                    packetWithMeta = obj;
                    p = packetWithMeta.getPacket();
                    packets.add(packetWithMeta);
                }
                ByteBuffer byteBuffer = this.getByteBuffer(p, groupContext, aioHandler);
                this.channelContext.traceClient(ClientAction.BEFORE_SEND, p, null);
                allBytebufferCapacity += byteBuffer.limit();
                ++packetCount;
                byteBuffers[i] = byteBuffer;
            }
            ByteBuffer allByteBuffer = ByteBuffer.allocate(allBytebufferCapacity);
            byte[] dest = allByteBuffer.array();
            for (ByteBuffer byteBuffer : byteBuffers) {
                if (byteBuffer == null) continue;
                int length = byteBuffer.limit();
                int position = allByteBuffer.position();
                System.arraycopy(byteBuffer.array(), 0, dest, position, length);
                allByteBuffer.position(position + length);
            }
            this.sendByteBuffer(allByteBuffer, packetCount, packets);
        } else {
            Object e = this.msgQueue.poll();
            obj = e;
            if (e != null) {
                boolean isPacket = obj instanceof Packet;
                if (isPacket) {
                    p = obj;
                    this.sendPacket(p);
                } else {
                    packetWithMeta = obj;
                    p = packetWithMeta.getPacket();
                    this.sendPacket(packetWithMeta);
                }
            }
        }
    }

    private ByteBuffer getByteBuffer(P packet, GroupContext<SessionContext, P, R> groupContext, AioHandler<SessionContext, P, R> aioHandler) {
        ByteBuffer byteBuffer = ((Packet)packet).getPreEncodedByteBuffer();
        byteBuffer = byteBuffer != null ? byteBuffer.duplicate() : aioHandler.encode(packet, groupContext, this.channelContext);
        return byteBuffer;
    }
}

