/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.threadpool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    private String threadPoolName = null;
    private static Map<String, DefaultThreadFactory> mapOfNameAndThreadFactory = new HashMap<String, DefaultThreadFactory>();
    private static Map<String, AtomicInteger> mapOfNameAndAtomicInteger = new HashMap<String, AtomicInteger>();
    private int priority = 5;

    public static DefaultThreadFactory getInstance(String threadName, Integer priority) {
        DefaultThreadFactory defaultThreadFactory = mapOfNameAndThreadFactory.get(threadName);
        if (defaultThreadFactory == null) {
            defaultThreadFactory = new DefaultThreadFactory();
            if (priority != null) {
                defaultThreadFactory.priority = priority;
            }
            defaultThreadFactory.setThreadName(threadName);
            mapOfNameAndThreadFactory.put(threadName, defaultThreadFactory);
            mapOfNameAndAtomicInteger.put(threadName, new AtomicInteger());
        }
        return defaultThreadFactory;
    }

    public static DefaultThreadFactory getInstance(String threadName) {
        return DefaultThreadFactory.getInstance(threadName, 5);
    }

    private DefaultThreadFactory() {
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        thread.setName(this.getThreadPoolName() + "-" + mapOfNameAndAtomicInteger.get(this.getThreadPoolName()).incrementAndGet());
        thread.setPriority(this.priority);
        return thread;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadName(String threadName) {
        this.threadPoolName = threadName;
    }
}

