/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.threadpool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.tio.core.threadpool.intf.SynRunnableIntf;

public class SynThreadPoolExecutor
extends ThreadPoolExecutor {
    private String name = null;

    public SynThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, BlockingQueue<Runnable> runnableQueue, ThreadFactory threadFactory, String name) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, runnableQueue, threadFactory);
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkBeforeExecute(Runnable runnable) {
        if (runnable instanceof SynRunnableIntf) {
            SynRunnableIntf synRunnableIntf = (SynRunnableIntf)runnable;
            ReadWriteLock runningLock = synRunnableIntf.runningLock();
            Lock writeLock = runningLock.writeLock();
            boolean tryLock = false;
            try {
                boolean bl = tryLock = writeLock.tryLock();
                return bl;
            }
            finally {
                if (tryLock) {
                    writeLock.unlock();
                }
            }
        }
        return true;
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.checkBeforeExecute(runnable)) {
            super.execute(runnable);
        }
    }

    public <R> Future<R> submit(Runnable runnable, R result) {
        if (this.checkBeforeExecute(runnable)) {
            Future<R> ret = super.submit(runnable, result);
            return ret;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

