/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SystemTimer {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final long tickUnit = Long.parseLong(System.getProperty("notify.systimer.tick", "10"));
    private static volatile long time = System.currentTimeMillis();

    public static long currentTimeMillis() {
        return time;
    }

    static {
        executor.scheduleAtFixedRate(new TimerTicker(), tickUnit, tickUnit, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                executor.shutdown();
            }
        });
    }

    private static class TimerTicker
    implements Runnable {
        private TimerTicker() {
        }

        @Override
        public void run() {
            time = System.currentTimeMillis();
        }
    }
}

