/*
 * Decompiled with CFR 0.152.
 */
package org.tio.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public abstract class Json {
    private static SerializeConfig mapping = new SerializeConfig();

    public static <T> T toBean(String jsonString, Class<T> tt) {
        try {
            if (StringUtils.isBlank((CharSequence)jsonString)) {
                return null;
            }
            Object t = JSON.parseObject((String)jsonString, tt);
            return (T)t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJson(Object bean) {
        try {
            return JSON.toJSONString((Object)bean, (SerializeConfig)mapping, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapping.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        mapping.put(java.sql.Date.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        mapping.put(Timestamp.class, (ObjectSerializer)new SimpleDateFormatSerializer("yyyy-MM-dd HH:mm:ss"));
        mapping.put(Time.class, (ObjectSerializer)new SimpleDateFormatSerializer("HH:mm:ss"));
    }
}

