/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Node;
import org.tio.core.intf.Packet;
import org.tio.core.threadpool.SynThreadPoolExecutor;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.ServerGroupContext;

public class AioServer<SessionContext, P extends Packet, R> {
    private static Logger log = LoggerFactory.getLogger(AioServer.class);
    private ServerGroupContext<SessionContext, P, R> serverGroupContext;
    private AsynchronousServerSocketChannel serverSocketChannel;
    private Node serverNode;
    private boolean isWaitingStop = false;

    public AioServer(ServerGroupContext<SessionContext, P, R> serverGroupContext) {
        this.serverGroupContext = serverGroupContext;
    }

    public ServerGroupContext<SessionContext, P, R> getServerGroupContext() {
        return this.serverGroupContext;
    }

    public AsynchronousServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }

    public void setServerGroupContext(ServerGroupContext<SessionContext, P, R> serverGroupContext) {
        this.serverGroupContext = serverGroupContext;
    }

    public void start(String serverIp, int serverPort) throws IOException {
        this.serverNode = new Node(serverIp, serverPort);
        AsynchronousChannelGroup channelGroup = AsynchronousChannelGroup.withThreadPool(this.serverGroupContext.getGroupExecutor());
        this.serverSocketChannel = AsynchronousServerSocketChannel.open(channelGroup);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.serverSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536);
        InetSocketAddress listenAddress = null;
        listenAddress = StringUtils.isBlank((CharSequence)serverIp) ? new InetSocketAddress(serverPort) : new InetSocketAddress(serverIp, serverPort);
        this.serverSocketChannel.bind(listenAddress, 0);
        AcceptCompletionHandler<SessionContext, P, R> acceptCompletionHandler = this.serverGroupContext.getAcceptCompletionHandler();
        this.serverSocketChannel.accept(this, acceptCompletionHandler);
        log.warn("t-io server started, listen on {}", (Object)this.serverNode);
    }

    public boolean stop() {
        this.isWaitingStop = true;
        boolean ret = true;
        try {
            this.serverSocketChannel.close();
        }
        catch (IOException e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        ThreadPoolExecutor groupExecutor = this.serverGroupContext.getGroupExecutor();
        SynThreadPoolExecutor tioExecutor = this.serverGroupContext.getTioExecutor();
        groupExecutor.shutdown();
        tioExecutor.shutdown();
        this.serverGroupContext.setStopped(true);
        try {
            ret = ret && groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        log.info(this.serverNode + " stopped");
        return ret;
    }

    public Node getServerNode() {
        return this.serverNode;
    }

    public boolean isWaitingStop() {
        return this.isWaitingStop;
    }

    public void setWaitingStop(boolean isWaitingStop) {
        this.isWaitingStop = isWaitingStop;
    }
}

