/*
 * Decompiled with CFR 0.152.
 */
package org.tio.server;

import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.ChannelStat;
import org.tio.core.GroupContext;
import org.tio.core.ObjWithLock;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.Packet;
import org.tio.core.stat.GroupStat;
import org.tio.core.utils.SystemTimer;
import org.tio.server.AcceptCompletionHandler;
import org.tio.server.DefaultServerAioListener;
import org.tio.server.ServerGroupStat;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;

public class ServerGroupContext<SessionContext, P extends Packet, R>
extends GroupContext<SessionContext, P, R> {
    static Logger log = LoggerFactory.getLogger(ServerGroupContext.class);
    private AcceptCompletionHandler<SessionContext, P, R> acceptCompletionHandler = null;
    private ServerAioHandler<SessionContext, P, R> serverAioHandler = null;
    private ServerAioListener<SessionContext, P, R> serverAioListener = null;
    protected ServerGroupStat serverGroupStat = new ServerGroupStat();
    private Thread checkHeartbeatThread = null;

    public ServerGroupContext(ServerAioHandler<SessionContext, P, R> serverAioHandler, ServerAioListener<SessionContext, P, R> serverAioListener) {
        this.acceptCompletionHandler = new AcceptCompletionHandler();
        this.serverAioHandler = serverAioHandler;
        this.serverAioListener = serverAioListener == null ? new DefaultServerAioListener() : serverAioListener;
        this.checkHeartbeatThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!ServerGroupContext.this.isStopped()) {
                    if (ServerGroupContext.this.heartbeatTimeout <= 0L) {
                        log.warn("\u7528\u6237\u53d6\u6d88\u4e86\u6846\u67b6\u5c42\u9762\u7684\u5fc3\u8df3\u68c0\u6d4b\uff0c\u8bf7\u7528\u6237\u81ea\u5df1\u53bb\u5b8c\u6210\u5fc3\u8df3\u673a\u5236");
                        break;
                    }
                    long start = SystemTimer.currentTimeMillis();
                    ObjWithLock objWithLock = ServerGroupContext.this.connections.getSetWithLock();
                    Set set = null;
                    ReentrantReadWriteLock.ReadLock readLock = objWithLock.getLock().readLock();
                    long start1 = 0L;
                    int count = 0;
                    try {
                        readLock.lock();
                        start1 = SystemTimer.currentTimeMillis();
                        set = objWithLock.getObj();
                        for (ChannelContext entry : set) {
                            ++count;
                            ChannelContext channelContext = entry;
                            ChannelStat stat = channelContext.getStat();
                            long timeLatestReceivedMsg = stat.getLatestTimeOfReceivedPacket();
                            long timeLatestSentMsg = stat.getLatestTimeOfSentPacket();
                            long compareTime = Math.max(timeLatestReceivedMsg, timeLatestSentMsg);
                            long currtime = SystemTimer.currentTimeMillis();
                            long interval = currtime - compareTime;
                            if (interval <= ServerGroupContext.this.heartbeatTimeout) continue;
                            log.warn("{}, {} ms\u6ca1\u6709\u6536\u53d1\u6d88\u606f", channelContext, (Object)interval);
                            Aio.remove(channelContext, interval + " ms\u6ca1\u6709\u6536\u53d1\u6d88\u606f");
                        }
                    }
                    catch (Throwable e) {
                        log.error("", e);
                    }
                    finally {
                        try {
                            readLock.unlock();
                            Thread.sleep(ServerGroupContext.this.heartbeatTimeout);
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                        }
                    }
                }
            }
        }, "tio-timer-checkheartbeat-" + this.id);
        this.checkHeartbeatThread.setDaemon(true);
        this.checkHeartbeatThread.setPriority(1);
        this.checkHeartbeatThread.start();
    }

    public ServerGroupStat getServerGroupStat() {
        return this.serverGroupStat;
    }

    public AcceptCompletionHandler<SessionContext, P, R> getAcceptCompletionHandler() {
        return this.acceptCompletionHandler;
    }

    public ServerAioHandler<SessionContext, P, R> getServerAioHandler() {
        return this.serverAioHandler;
    }

    public ServerAioListener<SessionContext, P, R> getServerAioListener() {
        return this.serverAioListener;
    }

    @Override
    public AioHandler<SessionContext, P, R> getAioHandler() {
        return this.getServerAioHandler();
    }

    @Override
    public GroupStat getGroupStat() {
        return this.getServerGroupStat();
    }

    @Override
    public AioListener<SessionContext, P, R> getAioListener() {
        return this.getServerAioListener();
    }
}

