/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.exception.errorcode;

import java.io.Serializable;
import org.tinygroup.exception.ErrorCode;
import org.tinygroup.exception.ErrorCodeParser;
import org.tinygroup.exception.constant.ErrorLevel;
import org.tinygroup.exception.constant.ErrorType;

public abstract class AbstractErrorCode
implements Serializable,
ErrorCodeParser,
ErrorCode,
Cloneable {
    public static final int VERSION = 0;
    public static final int PREFIX = 1;
    public static final int TYPE = 2;
    public static final int LEVEL = 3;
    public static final int SCENE = 4;
    public static final int NUMBER = 5;
    protected static final String DEFAULT_PREFIX = "TE";
    protected static final String DEFAULT_VERSION = "1";
    private static final long serialVersionUID = 4604190154626896337L;
    protected String errorPrefix = "TE";
    protected String version = "1";
    protected ErrorType errorType;
    protected ErrorLevel errorLevel;
    protected int errorScene;
    protected int errorNumber;

    public AbstractErrorCode() {
    }

    public AbstractErrorCode(String version, ErrorType errorType, ErrorLevel errorLevel, int errorScene, int errorNumber, String errorPrefix) {
        this.assertLength(0, version);
        this.assertLength(1, errorPrefix);
        this.assertLength(4, errorScene + "");
        this.assertLength(5, errorNumber + "");
        this.version = version;
        this.errorPrefix = errorPrefix;
        this.errorType = errorType;
        this.errorLevel = errorLevel;
        this.errorScene = errorScene;
        this.errorNumber = errorNumber;
    }

    protected abstract int[] getFieldLength();

    protected abstract String getErrorCodeFormatString();

    @Override
    public ErrorCode parse(String errorCode) {
        char[] chars = errorCode.toCharArray();
        try {
            ErrorCode code = (ErrorCode)this.clone();
            int position = 0;
            code.setVersion(errorCode.substring(position, this.getFieldLength()[0]));
            code.setErrorPrefix(errorCode.substring(position += this.getFieldLength()[0], position + this.getFieldLength()[1]));
            position += this.getFieldLength()[1];
            code.setErrorType(ErrorType.find(chars[position++] + ""));
            code.setErrorLevel(ErrorLevel.find(chars[position++] + ""));
            code.setErrorScene(Integer.parseInt(errorCode.substring(position, position + this.getFieldLength()[4])));
            code.setErrorNumber(Integer.parseInt(errorCode.substring(position += this.getFieldLength()[4], position + this.getFieldLength()[5])));
            return code;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertLength(int field, String errorPrefix) {
        if (errorPrefix == null || errorPrefix.length() != this.getFieldLength()[field]) {
            throw new IllegalArgumentException();
        }
    }

    public String toString() {
        return String.format(this.getErrorCodeFormatString(), this.version, this.errorPrefix, this.errorType.getType(), this.errorLevel.getLevel(), this.errorScene, this.errorNumber);
    }

    @Override
    public String getErrorPrefix() {
        return this.errorPrefix;
    }

    @Override
    public void setErrorPrefix(String errorPrefix) {
        this.errorPrefix = errorPrefix;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    @Override
    public ErrorLevel getErrorLevel() {
        return this.errorLevel;
    }

    @Override
    public void setErrorLevel(ErrorLevel errorLevel) {
        this.errorLevel = errorLevel;
    }

    @Override
    public int getErrorScene() {
        return this.errorScene;
    }

    @Override
    public void setErrorScene(int errorScene) {
        this.errorScene = errorScene;
    }

    @Override
    public int getErrorNumber() {
        return this.errorNumber;
    }

    @Override
    public void setErrorNumber(int errorNumber) {
        this.errorNumber = errorNumber;
    }
}

