/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.ModelSizeStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ModelSnapshot
implements JsonpSerializable {
    @Nullable
    private final String description;
    private final String jobId;
    private final int latestRecordTimeStamp;
    private final int latestResultTimeStamp;
    private final String minVersion;
    private final ModelSizeStats modelSizeStats;
    private final boolean retain;
    private final long snapshotDocCount;
    private final String snapshotId;
    private final long timestamp;
    public static final JsonpDeserializer<ModelSnapshot> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ModelSnapshot::setupModelSnapshotDeserializer);

    private ModelSnapshot(Builder builder) {
        this.description = builder.description;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.latestRecordTimeStamp = ApiTypeHelper.requireNonNull(builder.latestRecordTimeStamp, this, "latestRecordTimeStamp");
        this.latestResultTimeStamp = ApiTypeHelper.requireNonNull(builder.latestResultTimeStamp, this, "latestResultTimeStamp");
        this.minVersion = ApiTypeHelper.requireNonNull(builder.minVersion, this, "minVersion");
        this.modelSizeStats = ApiTypeHelper.requireNonNull(builder.modelSizeStats, this, "modelSizeStats");
        this.retain = ApiTypeHelper.requireNonNull(builder.retain, this, "retain");
        this.snapshotDocCount = ApiTypeHelper.requireNonNull(builder.snapshotDocCount, this, "snapshotDocCount");
        this.snapshotId = ApiTypeHelper.requireNonNull(builder.snapshotId, this, "snapshotId");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static ModelSnapshot of(Function<Builder, ObjectBuilder<ModelSnapshot>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final int latestRecordTimeStamp() {
        return this.latestRecordTimeStamp;
    }

    public final int latestResultTimeStamp() {
        return this.latestResultTimeStamp;
    }

    public final String minVersion() {
        return this.minVersion;
    }

    public final ModelSizeStats modelSizeStats() {
        return this.modelSizeStats;
    }

    public final boolean retain() {
        return this.retain;
    }

    public final long snapshotDocCount() {
        return this.snapshotDocCount;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("latest_record_time_stamp");
        generator.write(this.latestRecordTimeStamp);
        generator.writeKey("latest_result_time_stamp");
        generator.write(this.latestResultTimeStamp);
        generator.writeKey("min_version");
        generator.write(this.minVersion);
        generator.writeKey("model_size_stats");
        this.modelSizeStats.serialize(generator, mapper);
        generator.writeKey("retain");
        generator.write(this.retain);
        generator.writeKey("snapshot_doc_count");
        generator.write(this.snapshotDocCount);
        generator.writeKey("snapshot_id");
        generator.write(this.snapshotId);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupModelSnapshotDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::latestRecordTimeStamp, JsonpDeserializer.integerDeserializer(), "latest_record_time_stamp");
        op.add(Builder::latestResultTimeStamp, JsonpDeserializer.integerDeserializer(), "latest_result_time_stamp");
        op.add(Builder::minVersion, JsonpDeserializer.stringDeserializer(), "min_version");
        op.add(Builder::modelSizeStats, ModelSizeStats._DESERIALIZER, "model_size_stats");
        op.add(Builder::retain, JsonpDeserializer.booleanDeserializer(), "retain");
        op.add(Builder::snapshotDocCount, JsonpDeserializer.longDeserializer(), "snapshot_doc_count");
        op.add(Builder::snapshotId, JsonpDeserializer.stringDeserializer(), "snapshot_id");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ModelSnapshot> {
        @Nullable
        private String description;
        private String jobId;
        private Integer latestRecordTimeStamp;
        private Integer latestResultTimeStamp;
        private String minVersion;
        private ModelSizeStats modelSizeStats;
        private Boolean retain;
        private Long snapshotDocCount;
        private String snapshotId;
        private Long timestamp;

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder latestRecordTimeStamp(int value) {
            this.latestRecordTimeStamp = value;
            return this;
        }

        public final Builder latestResultTimeStamp(int value) {
            this.latestResultTimeStamp = value;
            return this;
        }

        public final Builder minVersion(String value) {
            this.minVersion = value;
            return this;
        }

        public final Builder modelSizeStats(ModelSizeStats value) {
            this.modelSizeStats = value;
            return this;
        }

        public final Builder modelSizeStats(Function<ModelSizeStats.Builder, ObjectBuilder<ModelSizeStats>> fn) {
            return this.modelSizeStats(fn.apply(new ModelSizeStats.Builder()).build());
        }

        public final Builder retain(boolean value) {
            this.retain = value;
            return this;
        }

        public final Builder snapshotDocCount(long value) {
            this.snapshotDocCount = value;
            return this;
        }

        public final Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ModelSnapshot build() {
            this._checkSingleUse();
            return new ModelSnapshot(this);
        }
    }
}

