/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class PreviewDataFrameAnalyticsResponse
implements JsonpSerializable {
    private final List<Map<String, String>> featureValues;
    public static final JsonpDeserializer<PreviewDataFrameAnalyticsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PreviewDataFrameAnalyticsResponse::setupPreviewDataFrameAnalyticsResponseDeserializer);

    private PreviewDataFrameAnalyticsResponse(Builder builder) {
        this.featureValues = ApiTypeHelper.unmodifiableRequired(builder.featureValues, (Object)this, "featureValues");
    }

    public static PreviewDataFrameAnalyticsResponse of(Function<Builder, ObjectBuilder<PreviewDataFrameAnalyticsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Map<String, String>> featureValues() {
        return this.featureValues;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.featureValues)) {
            generator.writeKey("feature_values");
            generator.writeStartArray();
            for (Map<String, String> item0 : this.featureValues) {
                generator.writeStartObject();
                if (item0 != null) {
                    for (Map.Entry<String, String> item1 : item0.entrySet()) {
                        generator.writeKey(item1.getKey());
                        generator.write(item1.getValue());
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupPreviewDataFrameAnalyticsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::featureValues, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer())), "feature_values");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PreviewDataFrameAnalyticsResponse> {
        private List<Map<String, String>> featureValues;

        public final Builder featureValues(List<Map<String, String>> list) {
            this.featureValues = Builder._listAddAll(this.featureValues, list);
            return this;
        }

        public final Builder featureValues(Map<String, String> value, Map<String, String> ... values) {
            this.featureValues = Builder._listAdd(this.featureValues, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PreviewDataFrameAnalyticsResponse build() {
            this._checkSingleUse();
            return new PreviewDataFrameAnalyticsResponse(this);
        }
    }
}

