/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterRetrieveException;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class StandaloneClusterDescriptor
implements ClusterDescriptor<StandaloneClusterId> {
    private final Configuration config;

    public StandaloneClusterDescriptor(Configuration config) {
        this.config = (Configuration)Preconditions.checkNotNull((Object)config);
    }

    @Override
    public String getClusterDescription() {
        String host = this.config.getString(JobManagerOptions.ADDRESS, "");
        int port = this.config.getInteger(JobManagerOptions.PORT, -1);
        return "Standalone cluster at " + host + ":" + port;
    }

    @Override
    public RestClusterClient<StandaloneClusterId> retrieve(StandaloneClusterId standaloneClusterId) throws ClusterRetrieveException {
        try {
            return new RestClusterClient<StandaloneClusterId>(this.config, standaloneClusterId);
        }
        catch (Exception e) {
            throw new ClusterRetrieveException("Couldn't retrieve standalone cluster", e);
        }
    }

    @Override
    public RestClusterClient<StandaloneClusterId> deploySessionCluster(ClusterSpecification clusterSpecification) {
        throw new UnsupportedOperationException("Can't deploy a standalone cluster.");
    }

    @Override
    public RestClusterClient<StandaloneClusterId> deployJobCluster(ClusterSpecification clusterSpecification, JobGraph jobGraph, boolean detached) {
        throw new UnsupportedOperationException("Can't deploy a standalone per-job cluster.");
    }

    @Override
    public void killCluster(StandaloneClusterId clusterId) throws FlinkException {
        throw new UnsupportedOperationException("Cannot terminate a standalone cluster.");
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void close() throws Exception {
    }
}

