/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ContextEnvironmentFactory;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

public class ContextEnvironment
extends ExecutionEnvironment {
    protected final ClusterClient<?> client;
    protected final List<URL> jarFilesToAttach;
    protected final List<URL> classpathsToAttach;
    protected final List<URI> libjars;
    protected final List<URI> files;
    protected final ClassLoader userCodeClassLoader;
    protected final SavepointRestoreSettings savepointSettings;

    public ContextEnvironment(ClusterClient<?> remoteConnection, List<URL> jarFiles, List<URL> classpaths, List<URI> libjars, List<URI> files, ClassLoader userCodeClassLoader, SavepointRestoreSettings savepointSettings) {
        this.client = remoteConnection;
        this.jarFilesToAttach = jarFiles;
        this.classpathsToAttach = classpaths;
        this.libjars = libjars;
        this.files = files;
        this.userCodeClassLoader = userCodeClassLoader;
        this.savepointSettings = savepointSettings;
    }

    public JobSubmissionResult executeInternal(String jobName, boolean detached) throws Exception {
        Plan p = this.createProgramPlan(jobName);
        JobWithJars toRun = new JobWithJars(p, this.jarFilesToAttach, this.classpathsToAttach, this.libjars, this.files, this.userCodeClassLoader);
        JobSubmissionResult submissionResult = this.client.run(toRun, this.getParallelism(), this.savepointSettings, detached);
        if (submissionResult.isJobExecutionResult()) {
            this.lastJobExecutionResult = submissionResult.getJobExecutionResult();
        }
        return this.lastJobExecutionResult;
    }

    public void cancel(JobID jobId) {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        this.client.shutDownCluster();
        try {
            this.client.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getExecutionPlan() throws Exception {
        Plan plan = this.createProgramPlan("unnamed job");
        OptimizedPlan op = ClusterClient.getOptimizedPlan(this.client.compiler, plan, this.getParallelism());
        PlanJSONDumpGenerator gen = new PlanJSONDumpGenerator();
        return gen.getOptimizerPlanAsJSON(op);
    }

    public void startNewSession() throws Exception {
        this.client.endSession(this.jobID);
        this.jobID = JobID.generate();
    }

    public String toString() {
        return "Context Environment (parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ") : " + this.getIdString();
    }

    public ClusterClient<?> getClient() {
        return this.client;
    }

    public List<URL> getJars() {
        return this.jarFilesToAttach;
    }

    public List<URL> getClasspaths() {
        return this.classpathsToAttach;
    }

    public List<URI> getLibjars() {
        return this.libjars;
    }

    public List<URI> getFiles() {
        return this.files;
    }

    public ClassLoader getUserCodeClassLoader() {
        return this.userCodeClassLoader;
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return this.savepointSettings;
    }

    static void setAsContext(ContextEnvironmentFactory factory) {
        ContextEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    static void unsetContext() {
        ContextEnvironment.resetContextEnvironment();
    }
}

