/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.accumulators;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.AbstractAccumulatorRegistry;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.preaggregatedaccumulators.AccumulatorAggregationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumulatorRegistry
extends AbstractAccumulatorRegistry {
    protected static final Logger LOG = LoggerFactory.getLogger(AccumulatorRegistry.class);
    private final JobID jobID;
    private final JobVertexID jobVertexID;
    private final int subtaskIndex;
    private final ExecutionAttemptID taskID;
    private final AccumulatorAggregationManager accumulatorAggregationManager;
    private final Map<String, Accumulator<?, ?>> preAggregatedUserAccumulators = new ConcurrentHashMap(4);

    public AccumulatorRegistry(JobID jobID, JobVertexID jobVertexID, int subtaskIndex, ExecutionAttemptID taskID, AccumulatorAggregationManager accumulatorAggregationManager) {
        this.jobID = jobID;
        this.jobVertexID = jobVertexID;
        this.subtaskIndex = subtaskIndex;
        this.taskID = taskID;
        this.accumulatorAggregationManager = accumulatorAggregationManager;
    }

    public AccumulatorSnapshot getSnapshot() {
        try {
            return new AccumulatorSnapshot(this.jobID, this.taskID, this.userAccumulators);
        }
        catch (Throwable e) {
            LOG.warn("Failed to serialize accumulators for task.", e);
            return null;
        }
    }

    public <V, A extends Serializable> void addPreAggregatedAccumulator(String name, Accumulator<V, A> accumulator) {
        if (this.preAggregatedUserAccumulators.containsKey(name)) {
            throw new UnsupportedOperationException("The accumulator '" + name + "' already exists and cannot be added.");
        }
        this.preAggregatedUserAccumulators.put(name, accumulator);
        this.accumulatorAggregationManager.registerPreAggregatedAccumulator(this.jobID, this.jobVertexID, this.subtaskIndex, name);
    }

    public Map<String, Accumulator<?, ?>> getPreAggregatedAccumulators() {
        return Collections.unmodifiableMap(this.preAggregatedUserAccumulators);
    }

    public void commitPreAggregatedAccumulator(String name) {
        if (!this.preAggregatedUserAccumulators.containsKey(name)) {
            throw new UnsupportedOperationException("The accumulator '" + name + "' does not exists.");
        }
        Accumulator<?, ?> accumulator = this.preAggregatedUserAccumulators.remove(name);
        this.accumulatorAggregationManager.commitPreAggregatedAccumulator(this.jobID, this.jobVertexID, this.subtaskIndex, name, accumulator);
    }

    public <V, A extends Serializable> CompletableFuture<Accumulator<V, A>> queryPreAggregatedAccumulator(String name) {
        return this.accumulatorAggregationManager.queryPreAggregatedAccumulator(this.jobID, name);
    }
}

