/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class SubtaskStateStats
implements Serializable {
    private static final long serialVersionUID = 8928594531621862214L;
    private final int subtaskIndex;
    private final long ackTimestamp;
    private final long stateSize;
    private final long fullStateSize;
    private final long syncCheckpointDuration;
    private final long asyncCheckpointDuration;
    private final long alignmentBuffered;
    private final long alignmentDuration;

    SubtaskStateStats(int subtaskIndex, long ackTimestamp, long stateSize, long fullStateSize, long syncCheckpointDuration, long asyncCheckpointDuration, long alignmentBuffered, long alignmentDuration) {
        Preconditions.checkArgument((subtaskIndex >= 0 ? 1 : 0) != 0, (Object)"Negative subtask index");
        this.subtaskIndex = subtaskIndex;
        Preconditions.checkArgument((stateSize >= 0L ? 1 : 0) != 0, (Object)"Negative state size");
        this.stateSize = stateSize;
        this.fullStateSize = fullStateSize;
        this.ackTimestamp = ackTimestamp;
        this.syncCheckpointDuration = syncCheckpointDuration;
        this.asyncCheckpointDuration = asyncCheckpointDuration;
        this.alignmentBuffered = alignmentBuffered;
        this.alignmentDuration = alignmentDuration;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public long getStateSize() {
        return this.stateSize;
    }

    public long getFullStateSize() {
        return this.fullStateSize;
    }

    public long getAckTimestamp() {
        return this.ackTimestamp;
    }

    public long getEndToEndDuration(long triggerTimestamp) {
        return Math.max(0L, this.ackTimestamp - triggerTimestamp);
    }

    public long getSyncCheckpointDuration() {
        return this.syncCheckpointDuration;
    }

    public long getAsyncCheckpointDuration() {
        return this.asyncCheckpointDuration;
    }

    public long getAlignmentBuffered() {
        return this.alignmentBuffered;
    }

    public long getAlignmentDuration() {
        return this.alignmentDuration;
    }
}

