/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.standalone;

import java.util.HashMap;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.resources.CommonExtendedResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.TaskManagerResource;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;

public class TaskManagerResourceCalculator {
    public static void main(String[] args) {
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        String configDir = parameterTool.get("configDir");
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)configDir);
        System.out.println(TaskManagerResourceCalculator.getTaskManagerResourceFromConf(configuration));
    }

    @VisibleForTesting
    public static String getTaskManagerResourceFromConf(Configuration configuration) {
        configuration.setLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN, configuration.getLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX));
        TaskManagerResource taskManagerResource = TaskManagerResource.fromConfiguration(configuration, TaskManagerResourceCalculator.initContainerResourceConfig(configuration), 1);
        return String.format("TotalHeapMemory:%s,YoungHeapMemory:%s,TotalDirectMemory:%s", taskManagerResource.getTotalHeapMemory(), taskManagerResource.getYoungHeapMemory(), taskManagerResource.getTotalDirectMemory());
    }

    public static int getTotalJavaMemorySizeMB(Configuration configuration) {
        TaskManagerResource taskManagerResource = TaskManagerResource.fromConfiguration(configuration, TaskManagerResourceCalculator.initContainerResourceConfig(configuration), 1);
        return taskManagerResource.getTotalHeapMemory() + taskManagerResource.getTotalDirectMemory();
    }

    public static long calculateNetworkBufferMemory(Configuration flinkConfig) {
        long networkBufBytes;
        if (TaskManagerServicesConfiguration.hasNewNetworkBufConf(flinkConfig)) {
            networkBufBytes = flinkConfig.getLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN);
        } else {
            int networkBuffersNum = flinkConfig.getInteger(TaskManagerOptions.NETWORK_NUM_BUFFERS);
            long pageSize = flinkConfig.getInteger(TaskManagerOptions.MEMORY_SEGMENT_SIZE);
            networkBufBytes = pageSize * (long)networkBuffersNum;
        }
        return networkBufBytes;
    }

    public static ResourceProfile initContainerResourceConfig(Configuration flinkConfig) {
        double core = flinkConfig.getDouble(TaskManagerOptions.TASK_MANAGER_CORE);
        int heapMemory = flinkConfig.getInteger(TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY);
        int nativeMemory = flinkConfig.getInteger(TaskManagerOptions.TASK_MANAGER_NATIVE_MEMORY);
        int directMemory = flinkConfig.getInteger(TaskManagerOptions.TASK_MANAGER_DIRECT_MEMORY);
        int networkMemory = (int)Math.ceil((double)TaskManagerResourceCalculator.calculateNetworkBufferMemory(flinkConfig) / 1048576.0);
        long managedMemory = flinkConfig.getLong(TaskManagerOptions.MANAGED_MEMORY_SIZE);
        HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
        resourceMap.put("MANAGED_MEMORY_MB", (Resource)new CommonExtendedResource("MANAGED_MEMORY_MB", (double)Math.max(0L, managedMemory)));
        long floatingManagedMemory = flinkConfig.getLong(TaskManagerOptions.FLOATING_MANAGED_MEMORY_SIZE);
        resourceMap.put("FLOATING_MANAGED_MEMORY_MB", (Resource)new CommonExtendedResource("FLOATING_MANAGED_MEMORY_MB", (double)Math.max(0L, floatingManagedMemory)));
        return new ResourceProfile(core, heapMemory, directMemory, nativeMemory, networkMemory, resourceMap);
    }
}

