/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.deployment.ExternalResultPartitionLocationTracker;
import org.apache.flink.runtime.deployment.InternalResultPartitionLocationTracker;
import org.apache.flink.runtime.deployment.ResultPartitionLocation;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.io.network.partition.BlockingShuffleType;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultPartitionLocationTrackerProxy {
    private static final Logger LOG = LoggerFactory.getLogger(ResultPartitionLocationTrackerProxy.class);
    private final Configuration configuration;
    private final InternalResultPartitionLocationTracker internalResultPartitionLocationTracker;
    private final ExternalResultPartitionLocationTracker externalResultPartitionLocationTracker;

    public ResultPartitionLocationTrackerProxy(Configuration configuration) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.internalResultPartitionLocationTracker = new InternalResultPartitionLocationTracker();
        this.externalResultPartitionLocationTracker = new ExternalResultPartitionLocationTracker(configuration);
    }

    public ResultPartitionLocation getResultPartitionLocation(TaskManagerLocation producerLocation, TaskManagerLocation consumerLocation, IntermediateResult intermediateResult) {
        BlockingShuffleType shuffleType = BlockingShuffleType.getBlockingShuffleTypeFromConfiguration(this.configuration, LOG);
        if (intermediateResult.getResultType() == ResultPartitionType.BLOCKING && shuffleType == BlockingShuffleType.YARN) {
            return this.externalResultPartitionLocationTracker.getResultPartitionLocation(producerLocation, consumerLocation, intermediateResult);
        }
        return this.internalResultPartitionLocationTracker.getResultPartitionLocation(producerLocation, consumerLocation, intermediateResult);
    }
}

