/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;

public class IntermediateResultPartition {
    private final IntermediateResult totalResult;
    private final ExecutionVertex producer;
    private final int partitionNumber;
    private IntermediateResultPartitionID partitionId;
    private List<List<ExecutionEdge>> consumers;
    private boolean dataProduced = false;
    private boolean isFinished = false;

    public IntermediateResultPartition(IntermediateResult totalResult, ExecutionVertex producer, int partitionNumber) {
        this.totalResult = totalResult;
        this.producer = producer;
        this.partitionNumber = partitionNumber;
        this.consumers = new ArrayList<List<ExecutionEdge>>(0);
        this.partitionId = new IntermediateResultPartitionID();
    }

    public ExecutionVertex getProducer() {
        return this.producer;
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public IntermediateResult getIntermediateResult() {
        return this.totalResult;
    }

    public void setPartitionId(IntermediateResultPartitionID id) {
        this.partitionId = id;
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultPartitionType getResultType() {
        return this.totalResult.getResultType();
    }

    public List<List<ExecutionEdge>> getConsumers() {
        return this.consumers;
    }

    public void resetForNewExecution() {
        if (this.isConsumable()) {
            this.getIntermediateResult().decrementNumberOfConsumablePartitions();
        }
        this.isFinished = false;
        this.dataProduced = false;
    }

    public void markDataProduced() {
        if (!this.isConsumable()) {
            this.getIntermediateResult().incrementNumberOfConsumablePartitions();
        }
        this.dataProduced = true;
    }

    public boolean hasDataProduced() {
        return this.dataProduced;
    }

    public boolean isConsumable() {
        if (this.getResultType().isPipelined()) {
            return this.dataProduced;
        }
        return this.isFinished;
    }

    int addConsumerGroup() {
        int pos = this.consumers.size();
        if (pos != 0) {
            throw new RuntimeException("Currently, each intermediate result can only have one consumer.");
        }
        this.consumers.add(new ArrayList());
        return pos;
    }

    void addConsumer(ExecutionEdge edge, int consumerNumber) {
        this.consumers.get(consumerNumber).add(edge);
    }

    public void markFinished() {
        if (this.getResultType().isBlocking() && !this.isConsumable()) {
            this.getIntermediateResult().incrementNumberOfConsumablePartitions();
        }
        this.isFinished = true;
    }
}

