/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class JobInformation
implements Serializable {
    private static final long serialVersionUID = 8367087049937822140L;
    private final JobID jobId;
    private final String jobName;
    private final long jobVersion;
    private final SerializedValue<ExecutionConfig> serializedExecutionConfig;
    private final Configuration jobConfiguration;
    private final Collection<PermanentBlobKey> requiredJarFileBlobKeys;
    private final Collection<URL> requiredClasspathURLs;

    public JobInformation(JobID jobId, String jobName, SerializedValue<ExecutionConfig> serializedExecutionConfig, Configuration jobConfiguration, Collection<PermanentBlobKey> requiredJarFileBlobKeys, Collection<URL> requiredClasspathURLs) {
        this(jobId, jobName, 0L, serializedExecutionConfig, jobConfiguration, requiredJarFileBlobKeys, requiredClasspathURLs);
    }

    public JobInformation(JobID jobId, String jobName, long jobVersion, SerializedValue<ExecutionConfig> serializedExecutionConfig, Configuration jobConfiguration, Collection<PermanentBlobKey> requiredJarFileBlobKeys, Collection<URL> requiredClasspathURLs) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.jobName = (String)Preconditions.checkNotNull((Object)jobName);
        this.jobVersion = jobVersion;
        this.serializedExecutionConfig = (SerializedValue)Preconditions.checkNotNull(serializedExecutionConfig);
        this.jobConfiguration = (Configuration)Preconditions.checkNotNull((Object)jobConfiguration);
        this.requiredJarFileBlobKeys = (Collection)Preconditions.checkNotNull(requiredJarFileBlobKeys);
        this.requiredClasspathURLs = (Collection)Preconditions.checkNotNull(requiredClasspathURLs);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public long getJobVersion() {
        return this.jobVersion;
    }

    public SerializedValue<ExecutionConfig> getSerializedExecutionConfig() {
        return this.serializedExecutionConfig;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public Collection<PermanentBlobKey> getRequiredJarFileBlobKeys() {
        return this.requiredJarFileBlobKeys;
    }

    public Collection<URL> getRequiredClasspathURLs() {
        return this.requiredClasspathURLs;
    }

    public String toString() {
        return "JobInformation for '" + this.jobName + "' (" + this.jobId + ')';
    }
}

