/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatistics;
import org.apache.flink.util.AbstractID;

public interface RestServerClient {
    public List<JobStatusMessage> listJob() throws Exception;

    public JobConfig getJobConfig(JobID var1);

    public JobStatus getJobStatus(JobID var1) throws Exception;

    public List<ExecutionVertexID> getTaskManagerTasks(String var1);

    public Map<String, List<ExecutionVertexID>> getAllTaskManagerTasks();

    public Map<JobVertexID, List<JobException>> getFailover(JobID var1, long var2, long var4) throws Exception;

    public Map<String, Map<Integer, Tuple2<Long, Double>>> getTaskMetrics(JobID var1, JobVertexID var2, Set<String> var3);

    public Map<String, Map<String, Tuple2<Long, Double>>> getTaskManagerMetrics(Set<String> var1, Set<String> var2);

    public Map<String, Map<String, Tuple2<Long, Double>>> getTaskManagerMetrics(JobID var1, Set<String> var2);

    public CompletableFuture<Acknowledge> rescale(JobID var1, Map<JobVertexID, Tuple2<Integer, ResourceSpec>> var2) throws IOException;

    public Map<Long, Exception> getTotalResourceLimitExceptions() throws Exception;

    public Map<String, List<Exception>> getTaskManagerExceptions(long var1, long var3) throws Exception;

    public CheckpointStatistics getLatestCheckPointStates(JobID var1) throws Exception;

    public static class JobStatus {
        private Map<ExecutionVertexID, Tuple2<Long, ExecutionState>> taskStatus;

        public JobStatus(Map<ExecutionVertexID, Tuple2<Long, ExecutionState>> taskStatus) {
            this.taskStatus = taskStatus;
        }

        public Map<ExecutionVertexID, Tuple2<Long, ExecutionState>> getTaskStatus() {
            return this.taskStatus;
        }
    }

    public static class JobConfig {
        private Configuration config;
        private Map<JobVertexID, VertexConfig> vertexConfigs;
        private Map<JobVertexID, List<Tuple2<JobVertexID, String>>> inputNodes;

        public JobConfig(Configuration config, Map<JobVertexID, VertexConfig> vertexConfigs, Map<JobVertexID, List<Tuple2<JobVertexID, String>>> inputNodes) {
            this.config = config;
            this.vertexConfigs = vertexConfigs;
            this.inputNodes = inputNodes;
        }

        public JobConfig(JobConfig other) {
            this.config = new Configuration(other.config);
            this.vertexConfigs = new HashMap<JobVertexID, VertexConfig>(other.vertexConfigs);
            this.inputNodes = new HashMap<JobVertexID, List<Tuple2<JobVertexID, String>>>(other.inputNodes);
        }

        public Configuration getConfig() {
            return this.config;
        }

        public Map<JobVertexID, VertexConfig> getVertexConfigs() {
            return this.vertexConfigs;
        }

        public Map<JobVertexID, List<Tuple2<JobVertexID, String>>> getInputNodes() {
            return this.inputNodes;
        }

        public double getJobTotalCpuCores() {
            double cpu = 0.0;
            for (VertexConfig vertexConfig : this.vertexConfigs.values()) {
                cpu += vertexConfig.getVertexTotalCpuCores();
            }
            return cpu;
        }

        public int getJobTotalMemoryMb() {
            int mem = 0;
            for (VertexConfig vertexConfig : this.vertexConfigs.values()) {
                mem += vertexConfig.getVertexTotalMemoryMb();
            }
            return mem;
        }
    }

    public static class VertexConfig {
        private int parallelism;
        private int maxParallelism;
        private AbstractID colocationGroupId;
        private ResourceSpec resourceSpec;
        private List<Integer> operatorIds;

        @VisibleForTesting
        public VertexConfig(int parallelism, int maxParallelism, ResourceSpec resourceSpec) {
            this(parallelism, maxParallelism, resourceSpec, null, null);
        }

        public VertexConfig(int parallelism, int maxParallelism, ResourceSpec resourceSpec, List<Integer> operatorIds) {
            this(parallelism, maxParallelism, resourceSpec, operatorIds, null);
        }

        public VertexConfig(int parallelism, int maxParallelism, ResourceSpec resourceSpec, List<Integer> operatorIds, AbstractID colocationGroupId) {
            this.parallelism = parallelism;
            this.maxParallelism = maxParallelism;
            this.resourceSpec = resourceSpec;
            this.operatorIds = operatorIds;
            this.colocationGroupId = colocationGroupId;
        }

        public int getParallelism() {
            return this.parallelism;
        }

        public int getMaxParallelism() {
            return this.maxParallelism;
        }

        public ResourceSpec getResourceSpec() {
            return this.resourceSpec;
        }

        public List<Integer> getOperatorIds() {
            return this.operatorIds;
        }

        public AbstractID getColocationGroupId() {
            return this.colocationGroupId;
        }

        public double getVertexTotalCpuCores() {
            return this.resourceSpec.getCpuCores() * (double)this.parallelism;
        }

        public int getVertexTotalMemoryMb() {
            return (this.resourceSpec.getHeapMemory() + this.resourceSpec.getDirectMemory() + this.resourceSpec.getNativeMemory()) * this.parallelism;
        }
    }
}

