/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.healthmanager.metrics.HealthMonitorMetricGroup;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;

public class HealthManagerMetricGroup
extends ComponentMetricGroup<HealthManagerMetricGroup> {
    private Map<JobID, HealthMonitorMetricGroup> jobMetrics = new HashMap<JobID, HealthMonitorMetricGroup>();

    public HealthManagerMetricGroup(MetricRegistry registry) {
        super(registry, new String[0], null);
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.jobMetrics.values();
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return "healthmanager";
    }

    @Override
    protected QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.JobManagerQueryScopeInfo();
    }

    public HealthMonitorMetricGroup addJob(JobID jobId, String jobName) {
        return this.jobMetrics.computeIfAbsent(jobId, k -> new HealthMonitorMetricGroup(this.registry, this, jobId, jobName, new String[]{jobId.toString(), jobName}));
    }

    public void removeJob(JobID jobID) {
        this.jobMetrics.remove(jobID).close();
    }
}

