/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.MetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class TaskManagerMetricSubscription
extends MetricSubscription<Tuple2<Long, Double>> {
    private String tmId;
    private TimelineAggregator timelineAggregator;

    public TaskManagerMetricSubscription(String tmId, String metricName, TimelineAggType timelineAggType, long interval) {
        super(metricName, timelineAggType, interval);
        this.tmId = tmId;
        this.timelineAggregator = TimelineAggregator.createTimelineAggregator(this.getTimelineAggType(), this.getInterval());
    }

    @Override
    public Tuple2<Long, Double> getValue() {
        return this.timelineAggregator.getValue();
    }

    public String getTmId() {
        return this.tmId;
    }

    public void addValue(Tuple2<Long, Double> value) {
        this.timelineAggregator.addValue(value);
    }
}

