/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.MetricAggFunction;
import org.apache.flink.runtime.healthmanager.metrics.MetricAggType;
import org.apache.flink.runtime.healthmanager.metrics.MetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class TaskMetricSubscription
extends MetricSubscription<Tuple2<Long, Double>> {
    private JobID jobID;
    private JobVertexID jobVertexID;
    private MetricAggFunction subtaskAggFunction;
    private MetricAggType subtaskAggType;
    private Map<Integer, TimelineAggregator> subtaskAggregators = new HashMap<Integer, TimelineAggregator>();

    public TaskMetricSubscription(JobID jobID, JobVertexID jobVertexID, MetricAggType subtaskAggType, String metricName, TimelineAggType timelineAggType, long interval) {
        super(metricName, timelineAggType, interval);
        this.jobID = jobID;
        this.jobVertexID = jobVertexID;
        this.subtaskAggFunction = MetricAggFunction.getMetricAggFunction(subtaskAggType);
        this.subtaskAggType = subtaskAggType;
    }

    @Override
    public Tuple2<Long, Double> getValue() {
        if (this.getSubTaskMetricValues().isEmpty()) {
            return null;
        }
        return this.subtaskAggFunction.getValue(this.getSubTaskMetricValues());
    }

    private List<Tuple2<Long, Double>> getSubTaskMetricValues() {
        ArrayList<Tuple2<Long, Double>> subtaskValues = new ArrayList<Tuple2<Long, Double>>(this.subtaskAggregators.size());
        for (TimelineAggregator timelineAggregator : this.subtaskAggregators.values()) {
            subtaskValues.add(timelineAggregator.getValue());
        }
        return subtaskValues;
    }

    public void addValue(Map<Integer, Tuple2<Long, Double>> subtaskMetrics) {
        if (subtaskMetrics.size() != this.subtaskAggregators.size()) {
            this.subtaskAggregators.clear();
        }
        for (Integer subtaskIndex : subtaskMetrics.keySet()) {
            if (!this.subtaskAggregators.containsKey(subtaskIndex)) {
                this.subtaskAggregators.put(subtaskIndex, TimelineAggregator.createTimelineAggregator(this.getTimelineAggType(), this.getInterval()));
            }
            this.subtaskAggregators.get(subtaskIndex).addValue(subtaskMetrics.get(subtaskIndex));
        }
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertexID;
    }
}

